# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AzureDevOpsPermissionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines who has admin permissions to the Azure DevOps pool."""

    INHERIT = "Inherit"
    """Pool will inherit permissions from the project or organization."""
    CREATOR_ONLY = "CreatorOnly"
    """Only the pool creator will be an admin of the pool."""
    SPECIFIC_ACCOUNTS = "SpecificAccounts"
    """Only the specified accounts will be admins of the pool."""


class CachingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of caching in a data disk."""

    NONE = "None"
    """Don't use host caching."""
    READ_ONLY = "ReadOnly"
    """For workloads that only do read operations."""
    READ_WRITE = "ReadWrite"
    """For workloads that do a balance of read and write operations."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class LogonType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines how the service should be run."""

    SERVICE = "Service"
    """Run as a service."""
    INTERACTIVE = "Interactive"
    """Run in interactive mode."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class OsDiskStorageAccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The storage account type of the OS disk."""

    STANDARD = "Standard"
    """Standard OS disk type."""
    PREMIUM = "Premium"
    """Premium OS disk type."""
    STANDARD_SSD = "StandardSSD"
    """Standard SSD OS disk type."""


class PredictionPreference(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines the balance between cost and performance."""

    BALANCED = "Balanced"
    """Balance between cost and performance."""
    MOST_COST_EFFECTIVE = "MostCostEffective"
    """Optimizes for cost over performance."""
    MORE_COST_EFFECTIVE = "MoreCostEffective"
    """Halfway through cost and balanced."""
    MORE_PERFORMANCE = "MorePerformance"
    """Halfway through balanced and performance."""
    BEST_PERFORMANCE = "BestPerformance"
    """Optimizes for performance over cost."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Represents a succeeded operation."""
    FAILED = "Failed"
    """Represents a failed operation."""
    CANCELED = "Canceled"
    """Represents a canceled operation."""
    PROVISIONING = "Provisioning"
    """Represents a pending operation."""
    UPDATING = "Updating"
    """Represents a pending operation."""
    DELETING = "Deleting"
    """Represents an operation under deletion."""
    ACCEPTED = "Accepted"
    """Represents an accepted operation."""


class ResourcePredictionsProfileType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines how the stand-by scheme should be provided."""

    MANUAL = "Manual"
    """Customer provides the stand-by agent scheme."""
    AUTOMATIC = "Automatic"
    """The stand-by agent scheme is determined based on historical demand."""


class ResourceSkuRestrictionsReasonCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the reason for SKU restriction."""

    QUOTA_ID = "QuotaId"
    """The restriction is due to exceeding a quota limitation."""
    NOT_AVAILABLE_FOR_SUBSCRIPTION = "NotAvailableForSubscription"
    """The restriction is not available for this subscription."""


class ResourceSkuRestrictionsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the kind of SKU restrictions that can exist."""

    LOCATION = "Location"
    """SKU restricted by location."""
    ZONE = "Zone"
    """SKU restricted by availability zone."""


class ResourceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the machine resource."""

    READY = "Ready"
    """Represents a machine resource that is ready."""
    NOT_READY = "NotReady"
    """Represents a machine resource that is not ready."""
    ALLOCATED = "Allocated"
    """Represents a machine resource that is allocated."""
    PENDING_RETURN = "PendingReturn"
    """Represents a machine resource that is pending return."""
    RETURNED = "Returned"
    """Represents a machine resource that is returned."""
    LEASED = "Leased"
    """Represents a machine resource that is leased."""
    PROVISIONING = "Provisioning"
    """Represents a machine resource that is provisioning."""
    UPDATING = "Updating"
    """Represents a machine resource that is updating."""
    STARTING = "Starting"
    """Represents a machine resource that is starting."""
    PENDING_REIMAGE = "PendingReimage"
    """Represents a machine resource that is pending reimage."""
    REIMAGING = "Reimaging"
    """Represents a machine resource that is reimaging."""


class StorageAccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """StorageAccountType enums."""

    STANDARD_LRS = "Standard_LRS"
    """The data disk should use standard locally redundant storage."""
    PREMIUM_LRS = "Premium_LRS"
    """The data disk should use premium locally redundant storage."""
    STANDARD_SSDLRS = "StandardSSD_LRS"
    """The data disk should use standard SSD locally redundant storage."""
    PREMIUM_ZRS = "Premium_ZRS"
    """The data disk should use premium SSD zonal redundant storage."""
    STANDARD_SSDZRS = "StandardSSD_ZRS"
    """The data disk should use standard SSD zonal redundant storage."""
