# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Access(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Access to be allowed or denied."""

    ALLOW = "Allow"
    DENY = "Deny"


class AccessRuleDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Direction that specifies whether the access rules is inbound/outbound."""

    INBOUND = "Inbound"
    OUTBOUND = "Outbound"


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the action to take on rule match."""

    ANOMALY_SCORING = "AnomalyScoring"
    ALLOW = "Allow"
    BLOCK = "Block"
    LOG = "Log"
    JS_CHALLENGE = "JSChallenge"


class AddressPrefixType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Address prefix type."""

    IP_PREFIX = "IPPrefix"
    SERVICE_TAG = "ServiceTag"
    NETWORK_GROUP = "NetworkGroup"


class AddressSpaceAggregationOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Option indicating the update behavior of a resource's address prefixes referenced within a
    network manager configuration.
    """

    NONE = "None"
    MANUAL = "Manual"


class AdminRuleKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether the rule is custom or default."""

    CUSTOM = "Custom"
    DEFAULT = "Default"


class AdminState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Property to indicate if the Express Route Gateway serves traffic when there are multiple
    Express Route Gateways in the vnet.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class AdvertisedPublicPrefixPropertiesValidationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Advertised Public Prefix State that denotes if the prefix is validated or not."""

    NOT_CONFIGURED = "NotConfigured"
    CONFIGURING = "Configuring"
    CONFIGURED = "Configured"
    VALIDATION_NEEDED = "ValidationNeeded"
    VALIDATION_FAILED = "ValidationFailed"
    MANUAL_VALIDATION_NEEDED = "ManualValidationNeeded"
    ASN_VALIDATION_FAILED = "AsnValidationFailed"
    CERTIFICATE_MISSING_IN_ROUTING_REGISTRY = "CertificateMissingInRoutingRegistry"
    INVALID_SIGNATURE_ENCODING = "InvalidSignatureEncoding"
    SIGNATURE_VERIFICATION_FAILED = "SignatureVerificationFailed"


class ApplicationGatewayBackendHealthServerHealth(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Health of backend server."""

    UNKNOWN = "Unknown"
    UP = "Up"
    DOWN = "Down"
    PARTIAL = "Partial"
    DRAINING = "Draining"


class ApplicationGatewayClientRevocationOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Verify client certificate revocation status."""

    NONE = "None"
    OCSP = "OCSP"


class ApplicationGatewayCookieBasedAffinity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cookie based affinity."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class ApplicationGatewayCustomErrorStatusCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status code of the application gateway custom error."""

    HTTP_STATUS400 = "HttpStatus400"
    HTTP_STATUS403 = "HttpStatus403"
    HTTP_STATUS404 = "HttpStatus404"
    HTTP_STATUS405 = "HttpStatus405"
    HTTP_STATUS408 = "HttpStatus408"
    HTTP_STATUS500 = "HttpStatus500"
    HTTP_STATUS502 = "HttpStatus502"
    HTTP_STATUS503 = "HttpStatus503"
    HTTP_STATUS504 = "HttpStatus504"


class ApplicationGatewayFirewallMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Web application firewall mode."""

    DETECTION = "Detection"
    PREVENTION = "Prevention"


class ApplicationGatewayFirewallRateLimitDuration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Duration over which Rate Limit policy will be applied. Applies only when ruleType is
    RateLimitRule.
    """

    ONE_MIN = "OneMin"
    FIVE_MINS = "FiveMins"


class ApplicationGatewayFirewallUserSessionVariable(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """User Session clause variable."""

    CLIENT_ADDR = "ClientAddr"
    GEO_LOCATION = "GeoLocation"
    NONE = "None"
    CLIENT_ADDR_XFF_HEADER = "ClientAddrXFFHeader"
    GEO_LOCATION_XFF_HEADER = "GeoLocationXFFHeader"


class ApplicationGatewayLoadDistributionAlgorithm(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Load Distribution Algorithm enums."""

    ROUND_ROBIN = "RoundRobin"
    LEAST_CONNECTIONS = "LeastConnections"
    IP_HASH = "IpHash"


class ApplicationGatewayOperationalState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operational state of the application gateway resource."""

    STOPPED = "Stopped"
    STARTING = "Starting"
    RUNNING = "Running"
    STOPPING = "Stopping"


class ApplicationGatewayProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Application Gateway protocol."""

    HTTP = "Http"
    """Supported for httpListeners and  backendHttpSettingsCollection properties."""
    HTTPS = "Https"
    """Supported for httpListeners and  backendHttpSettingsCollection properties."""
    TCP = "Tcp"
    """Supported for listeners and backendSettingsCollection properties."""
    TLS = "Tls"
    """Supported for listeners and backendSettingsCollection properties."""


class ApplicationGatewayRedirectType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Redirect type enum."""

    PERMANENT = "Permanent"
    FOUND = "Found"
    SEE_OTHER = "SeeOther"
    TEMPORARY = "Temporary"


class ApplicationGatewayRequestRoutingRuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Rule type."""

    BASIC = "Basic"
    PATH_BASED_ROUTING = "PathBasedRouting"


class ApplicationGatewayRuleSetStatusOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule set status."""

    PREVIEW = "Preview"
    GA = "GA"
    SUPPORTED = "Supported"
    DEPRECATED = "Deprecated"


class ApplicationGatewaySkuFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Family of an application gateway SKU."""

    GENERATION1 = "Generation_1"
    GENERATION2 = "Generation_2"


class ApplicationGatewaySkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of an application gateway SKU."""

    STANDARD_SMALL = "Standard_Small"
    STANDARD_MEDIUM = "Standard_Medium"
    STANDARD_LARGE = "Standard_Large"
    WAF_MEDIUM = "WAF_Medium"
    WAF_LARGE = "WAF_Large"
    STANDARD_V2 = "Standard_v2"
    WAF_V2 = "WAF_v2"
    BASIC = "Basic"


class ApplicationGatewaySslCipherSuite(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Ssl cipher suites enums."""

    TLS_ECDHE_RSA_WITH_AES256_CBC_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384"
    TLS_ECDHE_RSA_WITH_AES128_CBC_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"
    TLS_ECDHE_RSA_WITH_AES256_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"
    TLS_ECDHE_RSA_WITH_AES128_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA"
    TLS_DHE_RSA_WITH_AES256_GCM_SHA384 = "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384"
    TLS_DHE_RSA_WITH_AES128_GCM_SHA256 = "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"
    TLS_DHE_RSA_WITH_AES256_CBC_SHA = "TLS_DHE_RSA_WITH_AES_256_CBC_SHA"
    TLS_DHE_RSA_WITH_AES128_CBC_SHA = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA"
    TLS_RSA_WITH_AES256_GCM_SHA384 = "TLS_RSA_WITH_AES_256_GCM_SHA384"
    TLS_RSA_WITH_AES128_GCM_SHA256 = "TLS_RSA_WITH_AES_128_GCM_SHA256"
    TLS_RSA_WITH_AES256_CBC_SHA256 = "TLS_RSA_WITH_AES_256_CBC_SHA256"
    TLS_RSA_WITH_AES128_CBC_SHA256 = "TLS_RSA_WITH_AES_128_CBC_SHA256"
    TLS_RSA_WITH_AES256_CBC_SHA = "TLS_RSA_WITH_AES_256_CBC_SHA"
    TLS_RSA_WITH_AES128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA"
    TLS_ECDHE_ECDSA_WITH_AES256_GCM_SHA384 = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"
    TLS_ECDHE_ECDSA_WITH_AES128_GCM_SHA256 = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"
    TLS_ECDHE_ECDSA_WITH_AES256_CBC_SHA384 = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384"
    TLS_ECDHE_ECDSA_WITH_AES128_CBC_SHA256 = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"
    TLS_ECDHE_ECDSA_WITH_AES256_CBC_SHA = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA"
    TLS_ECDHE_ECDSA_WITH_AES128_CBC_SHA = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA"
    TLS_DHE_DSS_WITH_AES256_CBC_SHA256 = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256"
    TLS_DHE_DSS_WITH_AES128_CBC_SHA256 = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256"
    TLS_DHE_DSS_WITH_AES256_CBC_SHA = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA"
    TLS_DHE_DSS_WITH_AES128_CBC_SHA = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA"
    TLS_RSA_WITH3_DES_EDE_CBC_SHA = "TLS_RSA_WITH_3DES_EDE_CBC_SHA"
    TLS_DHE_DSS_WITH3_DES_EDE_CBC_SHA = "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA"
    TLS_ECDHE_RSA_WITH_AES128_GCM_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"
    TLS_ECDHE_RSA_WITH_AES256_GCM_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"


class ApplicationGatewaySslPolicyName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Ssl predefined policy name enums."""

    APP_GW_SSL_POLICY20150501 = "AppGwSslPolicy20150501"
    APP_GW_SSL_POLICY20170401 = "AppGwSslPolicy20170401"
    APP_GW_SSL_POLICY20170401_S = "AppGwSslPolicy20170401S"
    APP_GW_SSL_POLICY20220101 = "AppGwSslPolicy20220101"
    APP_GW_SSL_POLICY20220101_S = "AppGwSslPolicy20220101S"


class ApplicationGatewaySslPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Ssl Policy."""

    PREDEFINED = "Predefined"
    CUSTOM = "Custom"
    CUSTOM_V2 = "CustomV2"


class ApplicationGatewaySslProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Ssl protocol enums."""

    TL_SV1_0 = "TLSv1_0"
    TL_SV1_1 = "TLSv1_1"
    TL_SV1_2 = "TLSv1_2"
    TL_SV1_3 = "TLSv1_3"


class ApplicationGatewayTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Tier of an application gateway."""

    STANDARD = "Standard"
    WAF = "WAF"
    STANDARD_V2 = "Standard_v2"
    WAF_V2 = "WAF_v2"
    BASIC = "Basic"


class ApplicationGatewayTierTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ApplicationGatewayTierTypes."""

    STANDARD = "Standard"
    WAF = "WAF"
    STANDARD_V2 = "Standard_v2"
    WAF_V2 = "WAF_v2"


class ApplicationGatewayWafRuleActionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The string representation of the web application firewall rule action."""

    NONE = "None"
    ANOMALY_SCORING = "AnomalyScoring"
    ALLOW = "Allow"
    BLOCK = "Block"
    LOG = "Log"


class ApplicationGatewayWafRuleSensitivityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The string representation of the web application firewall rule sensitivity."""

    NONE = "None"
    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"


class ApplicationGatewayWafRuleStateTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The string representation of the web application firewall rule state."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class AssociationAccessMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Access mode on the association."""

    LEARNING = "Learning"
    ENFORCED = "Enforced"
    AUDIT = "Audit"


class AssociationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The association type of the child resource to the parent resource."""

    ASSOCIATED = "Associated"
    CONTAINS = "Contains"


class AuthenticationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VPN client authentication method."""

    EAPTLS = "EAPTLS"
    EAPMSCHA_PV2 = "EAPMSCHAPv2"


class AuthorizationUseStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The authorization use status."""

    AVAILABLE = "Available"
    IN_USE = "InUse"


class AutoLearnPrivateRangesMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation mode for automatically learning private ranges to not be SNAT."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class AzureFirewallApplicationRuleProtocolType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The protocol type of a Application Rule resource."""

    HTTP = "Http"
    HTTPS = "Https"
    MSSQL = "Mssql"


class AzureFirewallNatRCActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action type of a NAT rule collection."""

    SNAT = "Snat"
    DNAT = "Dnat"


class AzureFirewallNetworkRuleProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The protocol of a Network Rule resource."""

    TCP = "TCP"
    UDP = "UDP"
    ANY = "Any"
    ICMP = "ICMP"


class AzureFirewallPacketCaptureFlagsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The flags type to be captured."""

    FIN = "fin"
    SYN = "syn"
    RST = "rst"
    PUSH = "push"
    ACK = "ack"
    URG = "urg"


class AzureFirewallRCActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action type of a rule collection."""

    ALLOW = "Allow"
    DENY = "Deny"


class AzureFirewallSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of an Azure Firewall SKU."""

    AZFW_VNET = "AZFW_VNet"
    AZFW_HUB = "AZFW_Hub"


class AzureFirewallSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Tier of an Azure Firewall."""

    STANDARD = "Standard"
    PREMIUM = "Premium"
    BASIC = "Basic"


class AzureFirewallThreatIntelMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation mode for Threat Intel."""

    ALERT = "Alert"
    DENY = "Deny"
    OFF = "Off"


class BastionConnectProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The protocol used to connect to the target."""

    SSH = "SSH"
    RDP = "RDP"


class BastionHostSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the sku of this Bastion Host."""

    BASIC = "Basic"
    STANDARD = "Standard"
    DEVELOPER = "Developer"
    PREMIUM = "Premium"


class BgpPeerState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The BGP peer state."""

    UNKNOWN = "Unknown"
    STOPPED = "Stopped"
    IDLE = "Idle"
    CONNECTING = "Connecting"
    CONNECTED = "Connected"


class CircuitConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Express Route Circuit connection state."""

    CONNECTED = "Connected"
    CONNECTING = "Connecting"
    DISCONNECTED = "Disconnected"


class CommissionedState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The commissioned state of the Custom IP Prefix."""

    PROVISIONING = "Provisioning"
    PROVISIONED = "Provisioned"
    COMMISSIONING = "Commissioning"
    COMMISSIONED_NO_INTERNET_ADVERTISE = "CommissionedNoInternetAdvertise"
    COMMISSIONED = "Commissioned"
    DECOMMISSIONING = "Decommissioning"
    DEPROVISIONING = "Deprovisioning"
    DEPROVISIONED = "Deprovisioned"


class ConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Configuration Deployment Type."""

    SECURITY_ADMIN = "SecurityAdmin"
    CONNECTIVITY = "Connectivity"
    SECURITY_USER = "SecurityUser"
    ROUTING = "Routing"


class ConnectedGroupAddressOverlap(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Behavior to handle overlapped IP address space among members of the connected group of the
    connectivity configuration.
    """

    ALLOWED = "Allowed"
    """Default. Allows connected group members to have overlapping IP address space."""
    DISALLOWED = "Disallowed"
    """Strictly disallows connected group members from having overlapping IP address space. Prevents
    the addition of a virtual network with overlapping address to the connected group, blocks
    peering between a virtual network and a connected group member if any connected group member
    has an overlapping range, and restricts address space modifications that would introduce
    overlap."""


class ConnectedGroupPrivateEndpointsScale(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Option indicating the scale of private endpoints allowed in the connected group of the
    connectivity configuration.
    """

    STANDARD = "Standard"
    """Default. Allows for up to 2K private endpoints in the connected group."""
    HIGH_SCALE = "HighScale"
    """Allows for up to 20K private endpoints in the connected group."""


class ConnectionMonitorEndpointFilterItemType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of item included in the filter. Currently only 'AgentAddress' is supported."""

    AGENT_ADDRESS = "AgentAddress"


class ConnectionMonitorEndpointFilterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The behavior of the endpoint filter. Currently only 'Include' is supported."""

    INCLUDE = "Include"


class ConnectionMonitorSourceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of connection monitor source."""

    UNKNOWN = "Unknown"
    ACTIVE = "Active"
    INACTIVE = "Inactive"


class ConnectionMonitorTestConfigurationProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The protocol to use in test evaluation."""

    TCP = "Tcp"
    HTTP = "Http"
    ICMP = "Icmp"


class ConnectionMonitorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of connection monitor."""

    MULTI_ENDPOINT = "MultiEndpoint"
    SINGLE_SOURCE_DESTINATION = "SingleSourceDestination"


class ConnectionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The connection state."""

    REACHABLE = "Reachable"
    UNREACHABLE = "Unreachable"
    UNKNOWN = "Unknown"


class ConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The connection status."""

    UNKNOWN = "Unknown"
    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"
    DEGRADED = "Degraded"


class ConnectivityTopology(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Connectivity topology type."""

    HUB_AND_SPOKE = "HubAndSpoke"
    MESH = "Mesh"


class CoverageLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Test coverage for the endpoint."""

    DEFAULT = "Default"
    LOW = "Low"
    BELOW_AVERAGE = "BelowAverage"
    AVERAGE = "Average"
    ABOVE_AVERAGE = "AboveAverage"
    FULL = "Full"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class CustomIpPrefixType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of custom IP prefix. Should be Singular, Parent, or Child."""

    SINGULAR = "Singular"
    PARENT = "Parent"
    CHILD = "Child"


class DdosSettingsProtectionMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The DDoS protection mode of the public IP."""

    VIRTUAL_NETWORK_INHERITED = "VirtualNetworkInherited"
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class DeleteExistingPeering(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag if need to remove current existing peerings."""

    FALSE = "False"
    TRUE = "True"


class DeleteOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify what happens to the public IP address when the VM using it is deleted."""

    DELETE = "Delete"
    DETACH = "Detach"


class DeploymentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Deployment Status."""

    NOT_STARTED = "NotStarted"
    DEPLOYING = "Deploying"
    DEPLOYED = "Deployed"
    FAILED = "Failed"


class DestinationPortBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Destination port behavior."""

    NONE = "None"
    LISTEN_IF_AVAILABLE = "ListenIfAvailable"


class DhGroup(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The DH Groups used in IKE Phase 1 for initial SA."""

    NONE = "None"
    DH_GROUP1 = "DHGroup1"
    DH_GROUP2 = "DHGroup2"
    DH_GROUP14 = "DHGroup14"
    DH_GROUP2048 = "DHGroup2048"
    ECP256 = "ECP256"
    ECP384 = "ECP384"
    DH_GROUP24 = "DHGroup24"


class Direction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The direction of the traffic."""

    INBOUND = "Inbound"
    OUTBOUND = "Outbound"


class DisableBgpRoutePropagation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines whether BGP route propagation is enabled. Defaults to true."""

    FALSE = "False"
    TRUE = "True"


class EffectiveAdminRuleKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether the rule is custom or default."""

    CUSTOM = "Custom"
    DEFAULT = "Default"


class EffectiveRouteSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Who created the route."""

    UNKNOWN = "Unknown"
    USER = "User"
    VIRTUAL_NETWORK_GATEWAY = "VirtualNetworkGateway"
    DEFAULT = "Default"


class EffectiveRouteState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The value of effective route."""

    ACTIVE = "Active"
    INVALID = "Invalid"


class EffectiveSecurityRuleProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The network protocol this rule applies to."""

    TCP = "Tcp"
    UDP = "Udp"
    ALL = "All"


class EndpointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The endpoint type."""

    AZURE_VM = "AzureVM"
    AZURE_V_NET = "AzureVNet"
    AZURE_SUBNET = "AzureSubnet"
    EXTERNAL_ADDRESS = "ExternalAddress"
    MMA_WORKSPACE_MACHINE = "MMAWorkspaceMachine"
    MMA_WORKSPACE_NETWORK = "MMAWorkspaceNetwork"
    AZURE_ARC_VM = "AzureArcVM"
    AZURE_VMSS = "AzureVMSS"
    AZURE_ARC_NETWORK = "AzureArcNetwork"


class EvaluationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Connectivity analysis evaluation state."""

    NOT_STARTED = "NotStarted"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"


class ExceptionEntryMatchVariable(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The variable on which we evaluate the exception condition."""

    REQUEST_URI = "RequestURI"
    REMOTE_ADDR = "RemoteAddr"
    REQUEST_HEADER = "RequestHeader"


class ExceptionEntrySelectorMatchOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """When the matchVariable points to a key-value pair (e.g, RequestHeader), this operates on the
    selector.
    """

    EQUALS = "Equals"
    CONTAINS = "Contains"
    STARTS_WITH = "StartsWith"
    ENDS_WITH = "EndsWith"


class ExceptionEntryValueMatchOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operates on the allowed values for the matchVariable."""

    EQUALS = "Equals"
    CONTAINS = "Contains"
    STARTS_WITH = "StartsWith"
    ENDS_WITH = "EndsWith"
    IP_MATCH = "IPMatch"


class ExpressRouteCircuitPeeringAdvertisedPublicPrefixState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The advertised public prefix state of the Peering resource."""

    NOT_CONFIGURED = "NotConfigured"
    CONFIGURING = "Configuring"
    CONFIGURED = "Configured"
    VALIDATION_NEEDED = "ValidationNeeded"


class ExpressRouteCircuitPeeringState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of peering."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class ExpressRouteCircuitSkuFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The family of the SKU."""

    UNLIMITED_DATA = "UnlimitedData"
    METERED_DATA = "MeteredData"


class ExpressRouteCircuitSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The tier of the SKU."""

    STANDARD = "Standard"
    PREMIUM = "Premium"
    BASIC = "Basic"
    LOCAL = "Local"


class ExpressRouteLinkAdminState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Administrative state of the physical port."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class ExpressRouteLinkConnectorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Physical fiber port type."""

    LC = "LC"
    SC = "SC"


class ExpressRouteLinkMacSecCipher(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Mac security cipher."""

    GCM_AES256 = "GcmAes256"
    GCM_AES128 = "GcmAes128"
    GCM_AES_XPN128 = "GcmAesXpn128"
    GCM_AES_XPN256 = "GcmAesXpn256"


class ExpressRouteLinkMacSecSciState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sci mode enabled/disabled."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class ExpressRoutePeeringState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of peering."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class ExpressRoutePeeringType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The peering type."""

    AZURE_PUBLIC_PEERING = "AzurePublicPeering"
    AZURE_PRIVATE_PEERING = "AzurePrivatePeering"
    MICROSOFT_PEERING = "MicrosoftPeering"


class ExpressRoutePortAuthorizationUseStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The authorization use status."""

    AVAILABLE = "Available"
    IN_USE = "InUse"


class ExpressRoutePortsBillingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The billing type of the ExpressRoutePort resource."""

    METERED_DATA = "MeteredData"
    UNLIMITED_DATA = "UnlimitedData"


class ExpressRoutePortsEncapsulation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Encapsulation method on physical ports."""

    DOT1_Q = "Dot1Q"
    QIN_Q = "QinQ"


class ExtendedLocationTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The supported ExtendedLocation types. Currently only EdgeZone is supported in Microsoft.Network
    resources.
    """

    EDGE_ZONE = "EdgeZone"


class FailoverConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the connection."""

    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"


class FailoverTestStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the test."""

    NOT_STARTED = "NotStarted"
    STARTING = "Starting"
    RUNNING = "Running"
    START_FAILED = "StartFailed"
    STOPPING = "Stopping"
    COMPLETED = "Completed"
    STOP_FAILED = "StopFailed"
    INVALID = "Invalid"
    EXPIRED = "Expired"


class FailoverTestStatusForSingleTest(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the test."""

    NOT_STARTED = "NotStarted"
    STARTING = "Starting"
    RUNNING = "Running"
    START_FAILED = "StartFailed"
    STOPPING = "Stopping"
    COMPLETED = "Completed"
    STOP_FAILED = "StopFailed"
    INVALID = "Invalid"
    EXPIRED = "Expired"


class FailoverTestType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of failover test."""

    SINGLE_SITE_FAILOVER = "SingleSiteFailover"
    MULTI_SITE_FAILOVER = "MultiSiteFailover"
    ALL = "All"


class FirewallPolicyFilterRuleCollectionActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action type of a rule."""

    ALLOW = "Allow"
    DENY = "Deny"


class FirewallPolicyIDPSQuerySortOrder(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes if results should be in ascending/descending order."""

    ASCENDING = "Ascending"
    DESCENDING = "Descending"


class FirewallPolicyIDPSSignatureDirection(int, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes in which direction signature is being enforced: 0 - OutBound, 1 - InBound, 2 - Any, 3
    - Internal, 4 - InternalOutbound, 5 - InternalInbound.
    """

    ZERO = 0
    ONE = 1
    TWO = 2
    THREE = 3
    FOUR = 4
    FIVE = 5


class FirewallPolicyIDPSSignatureMode(int, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current mode enforced, 0 - Disabled, 1 - Alert, 2 -Deny."""

    ZERO = 0
    ONE = 1
    TWO = 2


class FirewallPolicyIDPSSignatureSeverity(int, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the severity of signature: 1 - High, 2 - Medium, 3 - Low."""

    ONE = 1
    TWO = 2
    THREE = 3


class FirewallPolicyIntrusionDetectionProfileType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible Intrusion Detection profile values."""

    BASIC = "Basic"
    STANDARD = "Standard"
    ADVANCED = "Advanced"
    EXTENDED = "Extended"


class FirewallPolicyIntrusionDetectionProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible intrusion detection bypass traffic protocols."""

    TCP = "TCP"
    UDP = "UDP"
    ICMP = "ICMP"
    ANY = "ANY"


class FirewallPolicyIntrusionDetectionStateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible state values."""

    OFF = "Off"
    ALERT = "Alert"
    DENY = "Deny"


class FirewallPolicyNatRuleCollectionActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action type of a rule."""

    DNAT = "DNAT"


class FirewallPolicyRuleApplicationProtocolType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The application protocol type of a Rule."""

    HTTP = "Http"
    HTTPS = "Https"


class FirewallPolicyRuleCollectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the rule collection."""

    FIREWALL_POLICY_NAT_RULE_COLLECTION = "FirewallPolicyNatRuleCollection"
    FIREWALL_POLICY_FILTER_RULE_COLLECTION = "FirewallPolicyFilterRuleCollection"


class FirewallPolicyRuleNetworkProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Network protocol of a Rule."""

    TCP = "TCP"
    UDP = "UDP"
    ANY = "Any"
    ICMP = "ICMP"


class FirewallPolicyRuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Rule Type."""

    APPLICATION_RULE = "ApplicationRule"
    NETWORK_RULE = "NetworkRule"
    NAT_RULE = "NatRule"


class FirewallPolicySkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Tier of Firewall Policy."""

    STANDARD = "Standard"
    PREMIUM = "Premium"
    BASIC = "Basic"


class FlowLogFormatType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The file type of flow log."""

    JSON = "JSON"


class GatewayLoadBalancerTunnelInterfaceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Traffic type of gateway load balancer tunnel interface."""

    NONE = "None"
    INTERNAL = "Internal"
    EXTERNAL = "External"


class GatewayLoadBalancerTunnelProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protocol of gateway load balancer tunnel interface."""

    NONE = "None"
    NATIVE = "Native"
    VXLAN = "VXLAN"


class Geo(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Geo for CIDR advertising. Should be an Geo code."""

    GLOBAL = "GLOBAL"
    AFRI = "AFRI"
    APAC = "APAC"
    EURO = "EURO"
    LATAM = "LATAM"
    NAM = "NAM"
    ME = "ME"
    OCEANIA = "OCEANIA"
    AQ = "AQ"
    GLOBAL_ENUM = "GLOBAL"


class GroupConnectivity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Group connectivity type."""

    NONE = "None"
    DIRECTLY_CONNECTED = "DirectlyConnected"


class GroupMemberType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network Group member type."""

    VIRTUAL_NETWORK = "VirtualNetwork"
    SUBNET = "Subnet"


class HTTPConfigurationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The HTTP method to use."""

    GET = "Get"
    POST = "Post"


class HTTPMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """HTTP method."""

    GET = "Get"


class HubBgpConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the VirtualHub to Peer."""

    UNKNOWN = "Unknown"
    CONNECTING = "Connecting"
    CONNECTED = "Connected"
    NOT_CONNECTED = "NotConnected"


class HubRoutingPreference(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The hub routing preference gateway types."""

    EXPRESS_ROUTE = "ExpressRoute"
    VPN_GATEWAY = "VpnGateway"
    AS_PATH = "ASPath"


class HubVirtualNetworkConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the VirtualHub to vnet connection."""

    UNKNOWN = "Unknown"
    CONNECTING = "Connecting"
    CONNECTED = "Connected"
    NOT_CONNECTED = "NotConnected"


class IkeEncryption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The IKE encryption algorithm (IKE phase 2)."""

    DES = "DES"
    DES3 = "DES3"
    AES128 = "AES128"
    AES192 = "AES192"
    AES256 = "AES256"
    GCMAES256 = "GCMAES256"
    GCMAES128 = "GCMAES128"


class IkeIntegrity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The IKE integrity algorithm (IKE phase 2)."""

    MD5 = "MD5"
    SHA1 = "SHA1"
    SHA256 = "SHA256"
    SHA384 = "SHA384"
    GCMAES256 = "GCMAES256"
    GCMAES128 = "GCMAES128"


class InboundSecurityRulesProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protocol. This should be either TCP or UDP."""

    TCP = "TCP"
    UDP = "UDP"


class InboundSecurityRuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Rule Type. This should be either AutoExpire or Permanent. Auto Expire Rule only creates NSG
    rules. Permanent Rule creates NSG rule and SLB LB Rule.
    """

    AUTO_EXPIRE = "AutoExpire"
    PERMANENT = "Permanent"


class IPAllocationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IP address allocation method."""

    STATIC = "Static"
    DYNAMIC = "Dynamic"


class IpAllocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IpAllocation type."""

    UNDEFINED = "Undefined"
    HYPERNET = "Hypernet"


class IpFlowProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protocol to be verified on."""

    TCP = "TCP"
    UDP = "UDP"


class IpsecEncryption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The IPSec encryption algorithm (IKE phase 1)."""

    NONE = "None"
    DES = "DES"
    DES3 = "DES3"
    AES128 = "AES128"
    AES192 = "AES192"
    AES256 = "AES256"
    GCMAES128 = "GCMAES128"
    GCMAES192 = "GCMAES192"
    GCMAES256 = "GCMAES256"


class IpsecIntegrity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The IPSec integrity algorithm (IKE phase 1)."""

    MD5 = "MD5"
    SHA1 = "SHA1"
    SHA256 = "SHA256"
    GCMAES128 = "GCMAES128"
    GCMAES192 = "GCMAES192"
    GCMAES256 = "GCMAES256"


class IpType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration to indicate the IP type."""

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"


class IPVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IP address version."""

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"


class IsGlobal(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag if global mesh is supported."""

    FALSE = "False"
    TRUE = "True"


class IssueType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of issue."""

    UNKNOWN = "Unknown"
    AGENT_STOPPED = "AgentStopped"
    GUEST_FIREWALL = "GuestFirewall"
    DNS_RESOLUTION = "DnsResolution"
    SOCKET_BIND = "SocketBind"
    NETWORK_SECURITY_RULE = "NetworkSecurityRule"
    USER_DEFINED_ROUTE = "UserDefinedRoute"
    PORT_THROTTLED = "PortThrottled"
    PLATFORM = "Platform"


class IsWorkloadProtected(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Value indicating whether the IP address is DDoS workload protected or not."""

    FALSE = "False"
    TRUE = "True"


class LoadBalancerBackendAddressAdminState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A list of administrative states which once set can override health probe so that Load Balancer
    will always forward new connections to backend, or deny new connections and reset existing
    connections.
    """

    NONE = "None"
    UP = "Up"
    DOWN = "Down"


class LoadBalancerOutboundRuleProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The protocol for the outbound rule in load balancer."""

    TCP = "Tcp"
    UDP = "Udp"
    ALL = "All"


class LoadBalancerSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of a load balancer SKU."""

    BASIC = "Basic"
    STANDARD = "Standard"
    GATEWAY = "Gateway"


class LoadBalancerSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Tier of a load balancer SKU."""

    REGIONAL = "Regional"
    GLOBAL = "Global"
    GLOBAL_ENUM = "Global"


class LoadDistribution(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The load distribution policy for this rule."""

    DEFAULT = "Default"
    SOURCE_IP = "SourceIP"
    SOURCE_IP_PROTOCOL = "SourceIPProtocol"


class ManagedRuleEnabledState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the managed rule. Defaults to Disabled if not specified."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class NatGatewaySkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of Nat Gateway SKU."""

    STANDARD = "Standard"
    STANDARD_V2 = "StandardV2"


class NetworkIntentPolicyBasedService(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network intent policy based services."""

    NONE = "None"
    ALL = "All"
    ALLOW_RULES_ONLY = "AllowRulesOnly"


class NetworkInterfaceAuxiliaryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Auxiliary mode of Network Interface resource."""

    NONE = "None"
    MAX_CONNECTIONS = "MaxConnections"
    FLOATING = "Floating"
    ACCELERATED_CONNECTIONS = "AcceleratedConnections"


class NetworkInterfaceAuxiliarySku(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Auxiliary sku of Network Interface resource."""

    NONE = "None"
    A1 = "A1"
    A2 = "A2"
    A4 = "A4"
    A8 = "A8"


class NetworkInterfaceMigrationPhase(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Migration phase of Network Interface resource."""

    NONE = "None"
    PREPARE = "Prepare"
    COMMIT = "Commit"
    ABORT = "Abort"
    COMMITTED = "Committed"


class NetworkInterfaceNicType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Network Interface resource."""

    STANDARD = "Standard"
    ELASTIC = "Elastic"


class NetworkOperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the Azure async operation."""

    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class NetworkProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network Protocol."""

    ANY = "Any"
    TCP = "TCP"
    UDP = "UDP"
    ICMP = "ICMP"


class NextHopType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Next hop type."""

    INTERNET = "Internet"
    VIRTUAL_APPLIANCE = "VirtualAppliance"
    VIRTUAL_NETWORK_GATEWAY = "VirtualNetworkGateway"
    VNET_LOCAL = "VnetLocal"
    HYPER_NET_GATEWAY = "HyperNetGateway"
    NONE = "None"


class NextStep(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported next step behaviors after a rule is applied to a matched route."""

    UNKNOWN = "Unknown"
    CONTINUE = "Continue"
    TERMINATE = "Terminate"
    CONTINUE_ENUM = "Continue"


class NicTypeInRequest(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """NIC type. This should be either PublicNic or PrivateNic."""

    PUBLIC_NIC = "PublicNic"
    PRIVATE_NIC = "PrivateNic"


class NicTypeInResponse(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """NIC type - PublicNic, PrivateNic, or AdditionalNic."""

    PUBLIC_NIC = "PublicNic"
    PRIVATE_NIC = "PrivateNic"
    ADDITIONAL_NIC = "AdditionalNic"


class NspLinkProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state of NSP Link/LinkReference."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    ACCEPTED = "Accepted"
    FAILED = "Failed"
    WAIT_FOR_REMOTE_COMPLETION = "WaitForRemoteCompletion"


class NspLinkStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The NSP link state."""

    APPROVED = "Approved"
    PENDING = "Pending"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class NspProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    ACCEPTED = "Accepted"
    FAILED = "Failed"


class OfficeTrafficCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The office traffic category."""

    OPTIMIZE = "Optimize"
    OPTIMIZE_AND_ALLOW = "OptimizeAndAllow"
    ALL = "All"
    NONE = "None"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The origin of the issue."""

    LOCAL = "Local"
    INBOUND = "Inbound"
    OUTBOUND = "Outbound"


class OutputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Connection monitor output destination type. Currently, only "Workspace" is supported."""

    WORKSPACE = "Workspace"


class OwaspCrsExclusionEntryMatchVariable(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The variable to be excluded."""

    REQUEST_HEADER_NAMES = "RequestHeaderNames"
    REQUEST_COOKIE_NAMES = "RequestCookieNames"
    REQUEST_ARG_NAMES = "RequestArgNames"
    REQUEST_HEADER_KEYS = "RequestHeaderKeys"
    REQUEST_HEADER_VALUES = "RequestHeaderValues"
    REQUEST_COOKIE_KEYS = "RequestCookieKeys"
    REQUEST_COOKIE_VALUES = "RequestCookieValues"
    REQUEST_ARG_KEYS = "RequestArgKeys"
    REQUEST_ARG_VALUES = "RequestArgValues"


class OwaspCrsExclusionEntrySelectorMatchOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """When matchVariable is a collection, operate on the selector to specify which elements in the
    collection this exclusion applies to.
    """

    EQUALS = "Equals"
    CONTAINS = "Contains"
    STARTS_WITH = "StartsWith"
    ENDS_WITH = "EndsWith"
    EQUALS_ANY = "EqualsAny"


class PacketCaptureTargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target type of the resource provided."""

    AZURE_VM = "AzureVM"
    AZURE_VMSS = "AzureVMSS"


class PcError(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PcError."""

    INTERNAL_ERROR = "InternalError"
    AGENT_STOPPED = "AgentStopped"
    CAPTURE_FAILED = "CaptureFailed"
    LOCAL_FILE_FAILED = "LocalFileFailed"
    STORAGE_FAILED = "StorageFailed"


class PcProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protocol to be filtered on."""

    TCP = "TCP"
    UDP = "UDP"
    ANY = "Any"


class PcStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the packet capture session."""

    NOT_STARTED = "NotStarted"
    RUNNING = "Running"
    STOPPED = "Stopped"
    ERROR = "Error"
    UNKNOWN = "Unknown"


class PeeringEnforcement(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Option indicating enforcement of peerings created by the connectivity configuration."""

    UNENFORCED = "Unenforced"
    """Default. Peerings created by the connectivity configuration may be modified or deleted outside
    of the network manager."""
    ENFORCED = "Enforced"
    """Peerings created by the connectivity configuration will not be modifiable or deletable outside
    of the network manager."""


class PfsGroup(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Pfs Groups used in IKE Phase 2 for new child SA."""

    NONE = "None"
    PFS1 = "PFS1"
    PFS2 = "PFS2"
    PFS2048 = "PFS2048"
    ECP256 = "ECP256"
    ECP384 = "ECP384"
    PFS24 = "PFS24"
    PFS14 = "PFS14"
    PFSMM = "PFSMM"


class PreferredIPVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The preferred IP version to use in test evaluation. The connection monitor may choose to use a
    different version depending on other parameters.
    """

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"


class PreferredRoutingGateway(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The preferred routing gateway types."""

    EXPRESS_ROUTE = "ExpressRoute"
    VPN_GATEWAY = "VpnGateway"
    NONE = "None"


class PrivateEndpointVNetPolicies(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Private Endpoint VNet Policies."""

    DISABLED = "Disabled"
    BASIC = "Basic"


class ProbeNoHealthyBackendsBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines how new connections are handled by the load balancer when all backend instances are
    probed down.
    """

    ALL_PROBED_DOWN = "AllProbedDown"
    """No new flows will be sent to the backend pool."""
    ALL_PROBED_UP = "AllProbedUp"
    """When all backend instances are probed down, incoming packets will be sent to all instances."""


class ProbeProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe
    to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI
    is required for the probe to be successful.
    """

    HTTP = "Http"
    TCP = "Tcp"
    HTTPS = "Https"


class ProcessorArchitecture(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VPN client Processor Architecture."""

    AMD64 = "Amd64"
    X86 = "X86"


class Protocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network protocol."""

    TCP = "Tcp"
    HTTP = "Http"
    HTTPS = "Https"
    ICMP = "Icmp"


class ProtocolType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RNM supported protocol types."""

    DO_NOT_USE = "DoNotUse"
    ICMP = "Icmp"
    TCP = "Tcp"
    UDP = "Udp"
    GRE = "Gre"
    ESP = "Esp"
    AH = "Ah"
    VXLAN = "Vxlan"
    ALL = "All"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning states of a resource."""

    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"


class PublicIpAddressDnsSettingsDomainNameLabelScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The domain name label scope. If a domain name label and a domain name label scope are
    specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with
    a hashed value includes in FQDN.
    """

    TENANT_REUSE = "TenantReuse"
    SUBSCRIPTION_REUSE = "SubscriptionReuse"
    RESOURCE_GROUP_REUSE = "ResourceGroupReuse"
    NO_REUSE = "NoReuse"


class PublicIPAddressMigrationPhase(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Migration phase of Public IP Address."""

    NONE = "None"
    PREPARE = "Prepare"
    COMMIT = "Commit"
    ABORT = "Abort"
    COMMITTED = "Committed"


class PublicIPAddressSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of a public IP address SKU."""

    BASIC = "Basic"
    STANDARD = "Standard"
    STANDARD_V2 = "StandardV2"


class PublicIPAddressSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Tier of a public IP address SKU."""

    REGIONAL = "Regional"
    GLOBAL = "Global"
    GLOBAL_ENUM = "Global"


class PublicIPPrefixSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of a public IP prefix SKU."""

    STANDARD = "Standard"
    STANDARD_V2 = "StandardV2"


class PublicIPPrefixSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Tier of a public IP prefix SKU."""

    REGIONAL = "Regional"
    GLOBAL = "Global"
    GLOBAL_ENUM = "Global"


class ResiliencyModel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Property to indicate if the Express Route Gateway has resiliency model of MultiHomed or
    SingleHomed.
    """

    SINGLE_HOMED = "SingleHomed"
    MULTI_HOMED = "MultiHomed"


class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes
    both an implicitly created identity and a set of user assigned identities. The type 'None' will
    remove any identities from the virtual machine.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class RouteFilterRuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule type of the rule."""

    COMMUNITY = "Community"


class RouteMapActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of actions which can be taken on a matched route. Add, Replace, Remove refer to parameters
    on the route, like community or prefix.
    """

    UNKNOWN = "Unknown"
    REMOVE = "Remove"
    ADD = "Add"
    REPLACE = "Replace"
    DROP = "Drop"


class RouteMapMatchCondition(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Match condition to apply RouteMap rules."""

    UNKNOWN = "Unknown"
    CONTAINS = "Contains"
    EQUALS = "Equals"
    NOT_CONTAINS = "NotContains"
    NOT_EQUALS = "NotEquals"


class RouteNextHopType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of Azure hop the packet should be sent to."""

    VIRTUAL_NETWORK_GATEWAY = "VirtualNetworkGateway"
    VNET_LOCAL = "VnetLocal"
    INTERNET = "Internet"
    VIRTUAL_APPLIANCE = "VirtualAppliance"
    NONE = "None"


class RoutingRuleDestinationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Routing rule destination type."""

    ADDRESS_PREFIX = "AddressPrefix"
    SERVICE_TAG = "ServiceTag"


class RoutingRuleNextHopType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Routing rule next hop type."""

    INTERNET = "Internet"
    NO_NEXT_HOP = "NoNextHop"
    VIRTUAL_APPLIANCE = "VirtualAppliance"
    VIRTUAL_NETWORK_GATEWAY = "VirtualNetworkGateway"
    VNET_LOCAL = "VnetLocal"


class RoutingState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current routing state of the VirtualHub."""

    NONE = "None"
    PROVISIONED = "Provisioned"
    PROVISIONING = "Provisioning"
    FAILED = "Failed"


class ScopeConnectionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current scope connection state."""

    CONNECTED = "Connected"
    PENDING = "Pending"
    CONFLICT = "Conflict"
    REVOKED = "Revoked"
    REJECTED = "Rejected"


class ScrubbingRuleEntryMatchOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """When matchVariable is a collection, operate on the selector to specify which elements in the
    collection this rule applies to.
    """

    EQUALS = "Equals"
    EQUALS_ANY = "EqualsAny"


class ScrubbingRuleEntryMatchVariable(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The variable to be scrubbed from the logs."""

    REQUEST_HEADER_NAMES = "RequestHeaderNames"
    REQUEST_COOKIE_NAMES = "RequestCookieNames"
    REQUEST_ARG_NAMES = "RequestArgNames"
    REQUEST_POST_ARG_NAMES = "RequestPostArgNames"
    REQUEST_JSON_ARG_NAMES = "RequestJSONArgNames"
    REQUEST_IP_ADDRESS = "RequestIPAddress"


class ScrubbingRuleEntryState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the state of log scrubbing rule. Default value is Enabled."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SecurityConfigurationRuleAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether network traffic is allowed or denied."""

    ALLOW = "Allow"
    DENY = "Deny"
    ALWAYS_ALLOW = "AlwaysAllow"


class SecurityConfigurationRuleDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The direction of the rule. The direction specifies if the rule will be evaluated on incoming or
    outgoing traffic.
    """

    INBOUND = "Inbound"
    OUTBOUND = "Outbound"


class SecurityConfigurationRuleProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network protocol this rule applies to."""

    TCP = "Tcp"
    UDP = "Udp"
    ICMP = "Icmp"
    ESP = "Esp"
    ANY = "Any"
    AH = "Ah"


class SecurityPartnerProviderConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the connection with Security Partner Provider."""

    UNKNOWN = "Unknown"
    PARTIALLY_CONNECTED = "PartiallyConnected"
    CONNECTED = "Connected"
    NOT_CONNECTED = "NotConnected"


class SecurityProviderName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Security Providers."""

    Z_SCALER = "ZScaler"
    I_BOSS = "IBoss"
    CHECKPOINT = "Checkpoint"


class SecurityRuleAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether network traffic is allowed or denied."""

    ALLOW = "Allow"
    DENY = "Deny"


class SecurityRuleDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The direction of the rule. The direction specifies if rule will be evaluated on incoming or
    outgoing traffic.
    """

    INBOUND = "Inbound"
    OUTBOUND = "Outbound"


class SecurityRuleProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network protocol this rule applies to."""

    TCP = "Tcp"
    UDP = "Udp"
    ICMP = "Icmp"
    ESP = "Esp"
    ASTERISK = "*"
    AH = "Ah"


class SensitivityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the sensitivity for the rule."""

    NONE = "None"
    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"


class ServiceProviderProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The ServiceProviderProvisioningState state of the resource."""

    NOT_PROVISIONED = "NotProvisioned"
    PROVISIONING = "Provisioning"
    PROVISIONED = "Provisioned"
    DEPROVISIONING = "Deprovisioning"


class Severity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The severity of the issue."""

    ERROR = "Error"
    WARNING = "Warning"


class SharingScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Set this property to Tenant to allow sharing subnet with other subscriptions in your AAD
    tenant. This property can only be set if defaultOutboundAccess is set to false, both properties
    can only be set if subnet is empty.
    """

    TENANT = "Tenant"
    DELEGATED_SERVICES = "DelegatedServices"


class SlotType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies slot info on a cloud service."""

    PRODUCTION = "Production"
    STAGING = "Staging"


class SyncMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Backend address synchronous mode for the backend pool."""

    AUTOMATIC = "Automatic"
    MANUAL = "Manual"


class SyncRemoteAddressSpace(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SyncRemoteAddressSpace."""

    TRUE = "true"


class TransportProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The transport protocol for the endpoint."""

    UDP = "Udp"
    TCP = "Tcp"
    ALL = "All"


class TunnelConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the tunnel."""

    UNKNOWN = "Unknown"
    CONNECTING = "Connecting"
    CONNECTED = "Connected"
    NOT_CONNECTED = "NotConnected"


class UsageUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An enum describing the unit of measurement."""

    COUNT = "Count"


class UseHubGateway(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag if need to use hub gateway."""

    FALSE = "False"
    TRUE = "True"


class VerbosityLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Verbosity level."""

    NORMAL = "Normal"
    MINIMUM = "Minimum"
    FULL = "Full"


class VirtualNetworkEncryptionEnforcement(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """If the encrypted VNet allows VM that does not support encryption. This field is for future
    support, AllowUnencrypted is the only supported value at general availability.
    """

    DROP_UNENCRYPTED = "DropUnencrypted"
    ALLOW_UNENCRYPTED = "AllowUnencrypted"


class VirtualNetworkGatewayConnectionMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gateway connection type."""

    DEFAULT = "Default"
    RESPONDER_ONLY = "ResponderOnly"
    INITIATOR_ONLY = "InitiatorOnly"


class VirtualNetworkGatewayConnectionProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gateway connection protocol."""

    IK_EV2 = "IKEv2"
    IK_EV1 = "IKEv1"


class VirtualNetworkGatewayConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Virtual Network Gateway connection status."""

    UNKNOWN = "Unknown"
    CONNECTING = "Connecting"
    CONNECTED = "Connected"
    NOT_CONNECTED = "NotConnected"


class VirtualNetworkGatewayConnectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gateway connection type."""

    I_PSEC = "IPsec"
    VNET2_VNET = "Vnet2Vnet"
    EXPRESS_ROUTE = "ExpressRoute"
    VPN_CLIENT = "VPNClient"


class VirtualNetworkGatewayMigrationPhase(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represent the current migration phase of gateway."""

    NONE = "None"
    """No migration phase set on gateway."""
    PREPARE = "Prepare"
    """Gateway is going through prepare migration or prepare has failed. Please see state and error
    details for more information."""
    PREPARE_SUCCEEDED = "PrepareSucceeded"
    """Prepare succeeded on gateway."""
    EXECUTE = "Execute"
    """Gateway is going through execute migration or execute has failed. Please see state and error
    details for more information."""
    EXECUTE_SUCCEEDED = "ExecuteSucceeded"
    """Execute succeeded on gateway."""
    COMMIT = "Commit"
    """Gateway is going through commit migration or commit has failed. Please see state and error
    details for more information."""
    COMMIT_SUCCEEDED = "CommitSucceeded"
    """Commit succeeded, represent migration is complete for the gateway."""
    ABORT_SUCCEEDED = "AbortSucceeded"
    """Represent abort succeeded on gateway, start with prepare to retrigger migration."""
    ABORT = "Abort"
    """Gateway is going through abort migration or abort has failed. Please see state and error
    details for more information."""


class VirtualNetworkGatewayMigrationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represent the current state of gateway migration."""

    NONE = "None"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class VirtualNetworkGatewayMigrationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MigrationType for the virtual network gateway."""

    UPGRADE_DEPLOYMENT_TO_STANDARD_IP = "UpgradeDeploymentToStandardIP"
    """Indicates that it is a migration process from basic IP CSES to standard IP VMSS."""


class VirtualNetworkGatewaySkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gateway SKU name."""

    BASIC = "Basic"
    HIGH_PERFORMANCE = "HighPerformance"
    STANDARD = "Standard"
    ULTRA_PERFORMANCE = "UltraPerformance"
    VPN_GW1 = "VpnGw1"
    VPN_GW2 = "VpnGw2"
    VPN_GW3 = "VpnGw3"
    VPN_GW4 = "VpnGw4"
    VPN_GW5 = "VpnGw5"
    VPN_GW1_AZ = "VpnGw1AZ"
    VPN_GW2_AZ = "VpnGw2AZ"
    VPN_GW3_AZ = "VpnGw3AZ"
    VPN_GW4_AZ = "VpnGw4AZ"
    VPN_GW5_AZ = "VpnGw5AZ"
    ER_GW1_AZ = "ErGw1AZ"
    ER_GW2_AZ = "ErGw2AZ"
    ER_GW3_AZ = "ErGw3AZ"
    ER_GW_SCALE = "ErGwScale"


class VirtualNetworkGatewaySkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gateway SKU tier."""

    BASIC = "Basic"
    HIGH_PERFORMANCE = "HighPerformance"
    STANDARD = "Standard"
    ULTRA_PERFORMANCE = "UltraPerformance"
    VPN_GW1 = "VpnGw1"
    VPN_GW2 = "VpnGw2"
    VPN_GW3 = "VpnGw3"
    VPN_GW4 = "VpnGw4"
    VPN_GW5 = "VpnGw5"
    VPN_GW1_AZ = "VpnGw1AZ"
    VPN_GW2_AZ = "VpnGw2AZ"
    VPN_GW3_AZ = "VpnGw3AZ"
    VPN_GW4_AZ = "VpnGw4AZ"
    VPN_GW5_AZ = "VpnGw5AZ"
    ER_GW1_AZ = "ErGw1AZ"
    ER_GW2_AZ = "ErGw2AZ"
    ER_GW3_AZ = "ErGw3AZ"
    ER_GW_SCALE = "ErGwScale"


class VirtualNetworkGatewayType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of this virtual network gateway."""

    VPN = "Vpn"
    EXPRESS_ROUTE = "ExpressRoute"
    LOCAL_GATEWAY = "LocalGateway"


class VirtualNetworkPeeringLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The peering sync status of the virtual network peering."""

    FULLY_IN_SYNC = "FullyInSync"
    REMOTE_NOT_IN_SYNC = "RemoteNotInSync"
    LOCAL_NOT_IN_SYNC = "LocalNotInSync"
    LOCAL_AND_REMOTE_NOT_IN_SYNC = "LocalAndRemoteNotInSync"


class VirtualNetworkPeeringState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the virtual network peering."""

    INITIATED = "Initiated"
    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"


class VirtualNetworkPrivateEndpointNetworkPolicies(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enable or Disable apply network policies on private end point in the subnet."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    NETWORK_SECURITY_GROUP_ENABLED = "NetworkSecurityGroupEnabled"
    ROUTE_TABLE_ENABLED = "RouteTableEnabled"


class VirtualNetworkPrivateLinkServiceNetworkPolicies(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enable or Disable apply network policies on private link service in the subnet."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class VirtualWanSecurityProviderType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The virtual wan security provider type."""

    EXTERNAL = "External"
    NATIVE = "Native"


class VnetLocalRouteOverrideCriteria(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in
    spoke vnet.
    """

    CONTAINS = "Contains"
    EQUAL = "Equal"


class VpnAuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VPN authentication types enabled for the virtual network gateway."""

    CERTIFICATE = "Certificate"
    RADIUS = "Radius"
    AAD = "AAD"


class VpnClientProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VPN client protocol enabled for the virtual network gateway."""

    IKE_V2 = "IkeV2"
    SSTP = "SSTP"
    OPEN_VPN = "OpenVPN"


class VpnConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the vpn connection."""

    UNKNOWN = "Unknown"
    CONNECTING = "Connecting"
    CONNECTED = "Connected"
    NOT_CONNECTED = "NotConnected"


class VpnGatewayGeneration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN."""

    NONE = "None"
    GENERATION1 = "Generation1"
    GENERATION2 = "Generation2"


class VpnGatewayTunnelingProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VPN protocol enabled for the VpnServerConfiguration."""

    IKE_V2 = "IkeV2"
    OPEN_VPN = "OpenVPN"


class VpnLinkConnectionMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Vpn link connection mode."""

    DEFAULT = "Default"
    RESPONDER_ONLY = "ResponderOnly"
    INITIATOR_ONLY = "InitiatorOnly"


class VpnNatRuleMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Source NAT direction of a VPN NAT."""

    EGRESS_SNAT = "EgressSnat"
    INGRESS_SNAT = "IngressSnat"


class VpnNatRuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of NAT rule for VPN NAT."""

    STATIC = "Static"
    DYNAMIC = "Dynamic"


class VpnPolicyMemberAttributeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Vpn Policy member attribute type."""

    CERTIFICATE_GROUP_ID = "CertificateGroupId"
    AAD_GROUP_ID = "AADGroupId"
    RADIUS_AZURE_GROUP_ID = "RadiusAzureGroupId"


class VpnType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of this virtual network gateway."""

    POLICY_BASED = "PolicyBased"
    ROUTE_BASED = "RouteBased"


class WebApplicationFirewallAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Actions."""

    ALLOW = "Allow"
    BLOCK = "Block"
    LOG = "Log"
    JS_CHALLENGE = "JSChallenge"


class WebApplicationFirewallEnabledState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the policy."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class WebApplicationFirewallMatchVariable(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Match Variable."""

    REMOTE_ADDR = "RemoteAddr"
    REQUEST_METHOD = "RequestMethod"
    QUERY_STRING = "QueryString"
    POST_ARGS = "PostArgs"
    REQUEST_URI = "RequestUri"
    REQUEST_HEADERS = "RequestHeaders"
    REQUEST_BODY = "RequestBody"
    REQUEST_COOKIES = "RequestCookies"


class WebApplicationFirewallMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode of the policy."""

    PREVENTION = "Prevention"
    DETECTION = "Detection"


class WebApplicationFirewallOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operator to be matched."""

    IP_MATCH = "IPMatch"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    LESS_THAN = "LessThan"
    GREATER_THAN = "GreaterThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    REGEX = "Regex"
    GEO_MATCH = "GeoMatch"
    ANY = "Any"


class WebApplicationFirewallPolicyResourceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource status of the policy."""

    CREATING = "Creating"
    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    DELETING = "Deleting"


class WebApplicationFirewallRuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule type."""

    MATCH_RULE = "MatchRule"
    RATE_LIMIT_RULE = "RateLimitRule"
    INVALID = "Invalid"


class WebApplicationFirewallScrubbingState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the log scrubbing config. Default value is Enabled."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class WebApplicationFirewallState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not
    specified.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class WebApplicationFirewallTransform(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Transforms applied before matching."""

    UPPERCASE = "Uppercase"
    LOWERCASE = "Lowercase"
    TRIM = "Trim"
    URL_DECODE = "UrlDecode"
    URL_ENCODE = "UrlEncode"
    REMOVE_NULLS = "RemoveNulls"
    HTML_ENTITY_DECODE = "HtmlEntityDecode"
