#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2021 Anna Lea
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Bad Dream series:
# - Bad Dream: Coma
# - Bad Dream: Fever
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250519.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID_COMA='bad-dream-coma'
GAME_NAME_COMA='Bad Dream: Coma'

GAME_ID_FEVER='bad-dream-fever'
GAME_NAME_FEVER='Bad Dream: Fever'

ARCHIVE_BASE_COMA_0_NAME='setup_bad_dream_coma_1.0_(26985).exe'
ARCHIVE_BASE_COMA_0_MD5='e4f0655ee22d99bdf09d0ee7a6980f23'
ARCHIVE_BASE_COMA_0_TYPE='innosetup'
ARCHIVE_BASE_COMA_0_SIZE='4100000'
ARCHIVE_BASE_COMA_0_VERSION='1.0-gog26985'
ARCHIVE_BASE_COMA_0_URL='https://www.gog.com/game/bad_dream_coma'

ARCHIVE_BASE_FEVER_0_NAME='setup_bad_dream_fever_1.0_(26985).exe'
ARCHIVE_BASE_FEVER_0_MD5='19336f3d5f3920873c7f111f9bda3f8b'
ARCHIVE_BASE_FEVER_0_TYPE='innosetup'
ARCHIVE_BASE_FEVER_0_SIZE='490000'
ARCHIVE_BASE_FEVER_0_VERSION='1.0-gog26985'
ARCHIVE_BASE_FEVER_0_URL='https://www.gog.com/game/bad_dream_fever'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
d3dx9_43.dll
options.ini'
CONTENT_GAME0_BIN_FILES_COMA='
bad dream coma.exe'
CONTENT_GAME0_BIN_FILES_FEVER='
bad dream fever.exe'
CONTENT_GAME_DATA_FILES='
language
splash.png
data.win
*.dat
*.ogg'

WINE_PERSISTENT_DIRECTORIES_COMA='
users/${USER}/Local Settings/Application Data/Bad_Dream_Coma'
WINE_PERSISTENT_DIRECTORIES_FEVER='
users/${USER}/Local Settings/Application Data/Bad_Dream_Fever'

APP_MAIN_EXE_COMA='bad dream coma.exe'
APP_MAIN_EXE_FEVER='bad dream fever.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID_COMA="${GAME_ID_COMA}-data"
PKG_DATA_ID_FEVER="${GAME_ID_FEVER}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
