//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armchaos

import "time"

// ActionStatus - Model that represents the an action and its status.
type ActionStatus struct {
	// READ-ONLY; The id of the action status.
	ActionID *string

	// READ-ONLY; The name of the action status.
	ActionName *string

	// READ-ONLY; String that represents the end time of the action.
	EndTime *time.Time

	// READ-ONLY; String that represents the start time of the action.
	StartTime *time.Time

	// READ-ONLY; The status of the action.
	Status *string

	// READ-ONLY; The array of targets.
	Targets []*ExperimentExecutionActionTargetDetailsProperties
}

// BranchStatus - Model that represents the a list of actions and action statuses.
type BranchStatus struct {
	// READ-ONLY; The array of actions.
	Actions []*ActionStatus

	// READ-ONLY; The id of the branch status.
	BranchID *string

	// READ-ONLY; The name of the branch status.
	BranchName *string

	// READ-ONLY; The status of the branch.
	Status *string
}

// Capability - Model that represents a Capability resource.
type Capability struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The properties of a capability resource.
	Properties *CapabilityProperties

	// READ-ONLY; The standard system metadata of a resource type.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CapabilityListResult - Model that represents a list of Capability resources and a link for pagination.
type CapabilityListResult struct {
	// READ-ONLY; URL to retrieve the next page of Capability resources.
	NextLink *string

	// READ-ONLY; List of Capability resources.
	Value []*Capability
}

// CapabilityProperties - Model that represents the Capability properties model.
type CapabilityProperties struct {
	// READ-ONLY; Localized string of the description.
	Description *string

	// READ-ONLY; URL to retrieve JSON schema of the Capability parameters.
	ParametersSchema *string

	// READ-ONLY; String of the Publisher that this Capability extends.
	Publisher *string

	// READ-ONLY; String of the Target Type that this Capability extends.
	TargetType *string

	// READ-ONLY; String of the URN for this Capability Type.
	Urn *string
}

// CapabilityType - Model that represents a Capability Type resource.
type CapabilityType struct {
	// Location of the Capability Type resource.
	Location *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The properties of the capability type resource.
	Properties *CapabilityTypeProperties

	// READ-ONLY; The system metadata properties of the capability type resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CapabilityTypeListResult - Model that represents a list of Capability Type resources and a link for pagination.
type CapabilityTypeListResult struct {
	// READ-ONLY; URL to retrieve the next page of Capability Type resources.
	NextLink *string

	// READ-ONLY; List of Capability Type resources.
	Value []*CapabilityType
}

// CapabilityTypeProperties - Model that represents the Capability Type properties model.
type CapabilityTypeProperties struct {
	// Control plane actions necessary to execute capability type.
	AzureRbacActions []*string

	// Data plane actions necessary to execute capability type.
	AzureRbacDataActions []*string

	// Runtime properties of this Capability Type.
	RuntimeProperties *CapabilityTypePropertiesRuntimeProperties

	// READ-ONLY; Localized string of the description.
	Description *string

	// READ-ONLY; Localized string of the display name.
	DisplayName *string

	// READ-ONLY; String of the kind of this Capability Type.
	Kind *string

	// READ-ONLY; URL to retrieve JSON schema of the Capability Type parameters.
	ParametersSchema *string

	// READ-ONLY; String of the Publisher that this Capability Type extends.
	Publisher *string

	// READ-ONLY; String of the Target Type that this Capability Type extends.
	TargetType *string

	// READ-ONLY; String of the URN for this Capability Type.
	Urn *string
}

// CapabilityTypePropertiesRuntimeProperties - Runtime properties of this Capability Type.
type CapabilityTypePropertiesRuntimeProperties struct {
	// READ-ONLY; String of the kind of the resource's action type (continuous or discrete).
	Kind *string
}

// ContinuousAction - Model that represents a continuous action.
type ContinuousAction struct {
	// REQUIRED; ISO8601 formatted string that represents a duration.
	Duration *string

	// REQUIRED; String that represents a Capability URN.
	Name *string

	// REQUIRED; List of key value pairs.
	Parameters []*KeyValuePair

	// REQUIRED; String that represents a selector.
	SelectorID *string

	// REQUIRED; Enum that discriminates between action models.
	Type *string
}

// GetExperimentAction implements the ExperimentActionClassification interface for type ContinuousAction.
func (c *ContinuousAction) GetExperimentAction() *ExperimentAction {
	return &ExperimentAction{
		Name: c.Name,
		Type: c.Type,
	}
}

// DelayAction - Model that represents a delay action.
type DelayAction struct {
	// REQUIRED; ISO8601 formatted string that represents a duration.
	Duration *string

	// REQUIRED; String that represents a Capability URN.
	Name *string

	// REQUIRED; Enum that discriminates between action models.
	Type *string
}

// GetExperimentAction implements the ExperimentActionClassification interface for type DelayAction.
func (d *DelayAction) GetExperimentAction() *ExperimentAction {
	return &ExperimentAction{
		Name: d.Name,
		Type: d.Type,
	}
}

// DiscreteAction - Model that represents a discrete action.
type DiscreteAction struct {
	// REQUIRED; String that represents a Capability URN.
	Name *string

	// REQUIRED; List of key value pairs.
	Parameters []*KeyValuePair

	// REQUIRED; String that represents a selector.
	SelectorID *string

	// REQUIRED; Enum that discriminates between action models.
	Type *string
}

// GetExperimentAction implements the ExperimentActionClassification interface for type DiscreteAction.
func (d *DiscreteAction) GetExperimentAction() *ExperimentAction {
	return &ExperimentAction{
		Name: d.Name,
		Type: d.Type,
	}
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// Experiment - Model that represents a Experiment resource.
type Experiment struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The properties of the experiment resource.
	Properties *ExperimentProperties

	// The identity of the experiment resource.
	Identity *ResourceIdentity

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata of the experiment resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ExperimentAction - Model that represents the base action model. 9 total per experiment.
type ExperimentAction struct {
	// REQUIRED; String that represents a Capability URN.
	Name *string

	// REQUIRED; Enum that discriminates between action models.
	Type *string
}

// GetExperimentAction implements the ExperimentActionClassification interface for type ExperimentAction.
func (e *ExperimentAction) GetExperimentAction() *ExperimentAction { return e }

// ExperimentBranch - Model that represents a branch in the step. 9 total per experiment.
type ExperimentBranch struct {
	// REQUIRED; List of actions.
	Actions []ExperimentActionClassification

	// REQUIRED; String of the branch name.
	Name *string
}

// ExperimentExecution - Model that represents the execution of a Experiment.
type ExperimentExecution struct {
	// The properties of experiment execution status.
	Properties *ExperimentExecutionProperties

	// READ-ONLY; String of the fully qualified resource ID.
	ID *string

	// READ-ONLY; String of the resource name.
	Name *string

	// READ-ONLY; String of the resource type.
	Type *string
}

// ExperimentExecutionActionTargetDetailsError - Model that represents the Experiment action target details error model.
type ExperimentExecutionActionTargetDetailsError struct {
	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error message
	Message *string
}

// ExperimentExecutionActionTargetDetailsProperties - Model that represents the Experiment action target details properties
// model.
type ExperimentExecutionActionTargetDetailsProperties struct {
	// READ-ONLY; The error of the action.
	Error *ExperimentExecutionActionTargetDetailsError

	// READ-ONLY; The status of the execution.
	Status *string

	// READ-ONLY; The target for the action.
	Target *string

	// READ-ONLY; String that represents the completed date time.
	TargetCompletedTime *time.Time

	// READ-ONLY; String that represents the failed date time.
	TargetFailedTime *time.Time
}

// ExperimentExecutionDetails - Model that represents the execution details of an Experiment.
type ExperimentExecutionDetails struct {
	// READ-ONLY; String of the fully qualified resource ID.
	ID *string

	// READ-ONLY; String of the resource name.
	Name *string

	// READ-ONLY; The properties of the experiment execution details.
	Properties *ExperimentExecutionDetailsProperties

	// READ-ONLY; String of the resource type.
	Type *string
}

// ExperimentExecutionDetailsProperties - Model that represents the extended properties of an experiment execution.
type ExperimentExecutionDetailsProperties struct {
	// READ-ONLY; The reason why the execution failed.
	FailureReason *string

	// READ-ONLY; String that represents the last action date time.
	LastActionAt *time.Time

	// READ-ONLY; The information of the experiment run.
	RunInformation *ExperimentExecutionDetailsPropertiesRunInformation

	// READ-ONLY; String that represents the start date time.
	StartedAt *time.Time

	// READ-ONLY; The status of the execution.
	Status *string

	// READ-ONLY; String that represents the stop date time.
	StoppedAt *time.Time
}

// ExperimentExecutionDetailsPropertiesRunInformation - The information of the experiment run.
type ExperimentExecutionDetailsPropertiesRunInformation struct {
	// READ-ONLY; The steps of the experiment run.
	Steps []*StepStatus
}

// ExperimentExecutionListResult - Model that represents a list of Experiment executions and a link for pagination.
type ExperimentExecutionListResult struct {
	// READ-ONLY; URL to retrieve the next page of Experiment executions.
	NextLink *string

	// READ-ONLY; List of Experiment executions.
	Value []*ExperimentExecution
}

// ExperimentExecutionProperties - Model that represents the execution properties of an Experiment.
type ExperimentExecutionProperties struct {
	// READ-ONLY; String that represents the start date time.
	StartedAt *time.Time

	// READ-ONLY; The status of the execution.
	Status *string

	// READ-ONLY; String that represents the stop date time.
	StoppedAt *time.Time
}

// ExperimentListResult - Model that represents a list of Experiment resources and a link for pagination.
type ExperimentListResult struct {
	// READ-ONLY; URL to retrieve the next page of Experiment resources.
	NextLink *string

	// READ-ONLY; List of Experiment resources.
	Value []*Experiment
}

// ExperimentProperties - Model that represents the Experiment properties model.
type ExperimentProperties struct {
	// REQUIRED; List of selectors.
	Selectors []TargetSelectorClassification

	// REQUIRED; List of steps.
	Steps []*ExperimentStep

	// READ-ONLY; Most recent provisioning state for the given experiment resource.
	ProvisioningState *ProvisioningState
}

// ExperimentStep - Model that represents a step in the Experiment resource.
type ExperimentStep struct {
	// REQUIRED; List of branches.
	Branches []*ExperimentBranch

	// REQUIRED; String of the step name.
	Name *string
}

// ExperimentUpdate - Describes an experiment update.
type ExperimentUpdate struct {
	// The identity of the experiment resource.
	Identity *ResourceIdentity
}

// KeyValuePair - A map to describe the settings of an action.
type KeyValuePair struct {
	// REQUIRED; The name of the setting for the action.
	Key *string

	// REQUIRED; The value of the setting for the action.
	Value *string
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// OperationStatus - The status of operation.
type OperationStatus struct {
	// The end time of the operation.
	EndTime *string

	// The error object.
	Error *ErrorDetail

	// The operation Id.
	ID *string

	// The operation name.
	Name *string

	// The start time of the operation.
	StartTime *string

	// The status of the operation.
	Status *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceIdentity - The identity of a resource.
type ResourceIdentity struct {
	// REQUIRED; String of the resource identity type.
	Type *ResourceIdentityType

	// The list of user identities associated with the Experiment. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; GUID that represents the principal ID of this resource identity.
	PrincipalID *string

	// READ-ONLY; GUID that represents the tenant ID of this resource identity.
	TenantID *string
}

// StepStatus - Model that represents the a list of branches and branch statuses.
type StepStatus struct {
	// READ-ONLY; The array of branches.
	Branches []*BranchStatus

	// READ-ONLY; The value of the status of the step.
	Status *string

	// READ-ONLY; The id of the step.
	StepID *string

	// READ-ONLY; The name of the step.
	StepName *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// Target - Model that represents a Target resource.
type Target struct {
	// REQUIRED; The properties of the target resource.
	Properties map[string]any

	// Location of the target resource.
	Location *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata of the target resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TargetFilter - Model that represents available filter types that can be applied to a targets list.
type TargetFilter struct {
	// REQUIRED; Enum that discriminates between filter types. Currently only Simple type is supported.
	Type *FilterType
}

// GetTargetFilter implements the TargetFilterClassification interface for type TargetFilter.
func (t *TargetFilter) GetTargetFilter() *TargetFilter { return t }

// TargetListResult - Model that represents a list of Target resources and a link for pagination.
type TargetListResult struct {
	// READ-ONLY; URL to retrieve the next page of Target resources.
	NextLink *string

	// READ-ONLY; List of Target resources.
	Value []*Target
}

// TargetListSelector - Model that represents a list selector.
type TargetListSelector struct {
	// REQUIRED; String of the selector ID.
	ID *string

	// REQUIRED; List of Target references.
	Targets []*TargetReference

	// REQUIRED; Enum of the selector type.
	Type *SelectorType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Model that represents available filter types that can be applied to a targets list.
	Filter TargetFilterClassification
}

// GetTargetSelector implements the TargetSelectorClassification interface for type TargetListSelector.
func (t *TargetListSelector) GetTargetSelector() *TargetSelector {
	return &TargetSelector{
		AdditionalProperties: t.AdditionalProperties,
		Filter:               t.Filter,
		ID:                   t.ID,
		Type:                 t.Type,
	}
}

// TargetQuerySelector - Model that represents a query selector.
type TargetQuerySelector struct {
	// REQUIRED; String of the selector ID.
	ID *string

	// REQUIRED; Azure Resource Graph (ARG) Query Language query for target resources.
	QueryString *string

	// REQUIRED; Subscription id list to scope resource query.
	SubscriptionIDs []*string

	// REQUIRED; Enum of the selector type.
	Type *SelectorType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Model that represents available filter types that can be applied to a targets list.
	Filter TargetFilterClassification
}

// GetTargetSelector implements the TargetSelectorClassification interface for type TargetQuerySelector.
func (t *TargetQuerySelector) GetTargetSelector() *TargetSelector {
	return &TargetSelector{
		AdditionalProperties: t.AdditionalProperties,
		Filter:               t.Filter,
		ID:                   t.ID,
		Type:                 t.Type,
	}
}

// TargetReference - Model that represents a reference to a Target in the selector.
type TargetReference struct {
	// REQUIRED; String of the resource ID of a Target resource.
	ID *string

	// REQUIRED; Enum of the Target reference type.
	Type *TargetReferenceType
}

// TargetSelector - Model that represents a selector in the Experiment resource.
type TargetSelector struct {
	// REQUIRED; String of the selector ID.
	ID *string

	// REQUIRED; Enum of the selector type.
	Type *SelectorType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Model that represents available filter types that can be applied to a targets list.
	Filter TargetFilterClassification
}

// GetTargetSelector implements the TargetSelectorClassification interface for type TargetSelector.
func (t *TargetSelector) GetTargetSelector() *TargetSelector { return t }

// TargetSimpleFilter - Model that represents a simple target filter.
type TargetSimpleFilter struct {
	// REQUIRED; Enum that discriminates between filter types. Currently only Simple type is supported.
	Type *FilterType

	// Model that represents the Simple filter parameters.
	Parameters *TargetSimpleFilterParameters
}

// GetTargetFilter implements the TargetFilterClassification interface for type TargetSimpleFilter.
func (t *TargetSimpleFilter) GetTargetFilter() *TargetFilter {
	return &TargetFilter{
		Type: t.Type,
	}
}

// TargetSimpleFilterParameters - Model that represents the Simple filter parameters.
type TargetSimpleFilterParameters struct {
	// List of Azure availability zones to filter targets by.
	Zones []*string
}

// TargetType - Model that represents a Target Type resource.
type TargetType struct {
	// REQUIRED; The properties of the target type resource.
	Properties *TargetTypeProperties

	// Location of the Target Type resource.
	Location *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata properties of the target type resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TargetTypeListResult - Model that represents a list of Target Type resources and a link for pagination.
type TargetTypeListResult struct {
	// READ-ONLY; URL to retrieve the next page of Target Type resources.
	NextLink *string

	// READ-ONLY; List of Target Type resources.
	Value []*TargetType
}

// TargetTypeProperties - Model that represents the base Target Type properties model.
type TargetTypeProperties struct {
	// READ-ONLY; Localized string of the description.
	Description *string

	// READ-ONLY; Localized string of the display name.
	DisplayName *string

	// READ-ONLY; URL to retrieve JSON schema of the Target Type properties.
	PropertiesSchema *string

	// READ-ONLY; List of resource types this Target Type can extend.
	ResourceTypes []*string
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}
