//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armpolicy.ClientFactory type.
type ServerFactory struct {
	AssignmentsServer         AssignmentsServer
	DataPolicyManifestsServer DataPolicyManifestsServer
	DefinitionsServer         DefinitionsServer
	ExemptionsServer          ExemptionsServer
	SetDefinitionsServer      SetDefinitionsServer
	VariableValuesServer      VariableValuesServer
	VariablesServer           VariablesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armpolicy.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armpolicy.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                         *ServerFactory
	trMu                        sync.Mutex
	trAssignmentsServer         *AssignmentsServerTransport
	trDataPolicyManifestsServer *DataPolicyManifestsServerTransport
	trDefinitionsServer         *DefinitionsServerTransport
	trExemptionsServer          *ExemptionsServerTransport
	trSetDefinitionsServer      *SetDefinitionsServerTransport
	trVariableValuesServer      *VariableValuesServerTransport
	trVariablesServer           *VariablesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AssignmentsClient":
		initServer(s, &s.trAssignmentsServer, func() *AssignmentsServerTransport { return NewAssignmentsServerTransport(&s.srv.AssignmentsServer) })
		resp, err = s.trAssignmentsServer.Do(req)
	case "DataPolicyManifestsClient":
		initServer(s, &s.trDataPolicyManifestsServer, func() *DataPolicyManifestsServerTransport {
			return NewDataPolicyManifestsServerTransport(&s.srv.DataPolicyManifestsServer)
		})
		resp, err = s.trDataPolicyManifestsServer.Do(req)
	case "DefinitionsClient":
		initServer(s, &s.trDefinitionsServer, func() *DefinitionsServerTransport { return NewDefinitionsServerTransport(&s.srv.DefinitionsServer) })
		resp, err = s.trDefinitionsServer.Do(req)
	case "ExemptionsClient":
		initServer(s, &s.trExemptionsServer, func() *ExemptionsServerTransport { return NewExemptionsServerTransport(&s.srv.ExemptionsServer) })
		resp, err = s.trExemptionsServer.Do(req)
	case "SetDefinitionsClient":
		initServer(s, &s.trSetDefinitionsServer, func() *SetDefinitionsServerTransport {
			return NewSetDefinitionsServerTransport(&s.srv.SetDefinitionsServer)
		})
		resp, err = s.trSetDefinitionsServer.Do(req)
	case "VariableValuesClient":
		initServer(s, &s.trVariableValuesServer, func() *VariableValuesServerTransport {
			return NewVariableValuesServerTransport(&s.srv.VariableValuesServer)
		})
		resp, err = s.trVariableValuesServer.Do(req)
	case "VariablesClient":
		initServer(s, &s.trVariablesServer, func() *VariablesServerTransport { return NewVariablesServerTransport(&s.srv.VariablesServer) })
		resp, err = s.trVariablesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
