# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementAzureMonitorWorkspacesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_azure_monitor_workspaces_list_by_resource_group(self, resource_group):
        response = self.client.azure_monitor_workspaces.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-04-03",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_azure_monitor_workspaces_list_by_subscription(self, resource_group):
        response = self.client.azure_monitor_workspaces.list_by_subscription(
            api_version="2023-04-03",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_azure_monitor_workspaces_get(self, resource_group):
        response = self.client.azure_monitor_workspaces.get(
            resource_group_name=resource_group.name,
            azure_monitor_workspace_name="str",
            api_version="2023-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_azure_monitor_workspaces_create(self, resource_group):
        response = self.client.azure_monitor_workspaces.create(
            resource_group_name=resource_group.name,
            azure_monitor_workspace_name="str",
            azure_monitor_workspace_properties={
                "location": "str",
                "accountId": "str",
                "defaultIngestionSettings": {
                    "dataCollectionEndpointResourceId": "str",
                    "dataCollectionRuleResourceId": "str",
                },
                "etag": "str",
                "id": "str",
                "metrics": {"internalId": "str", "prometheusQueryEndpoint": "str"},
                "name": "str",
                "privateEndpointConnections": [
                    {
                        "groupIds": ["str"],
                        "id": "str",
                        "name": "str",
                        "privateEndpoint": {"id": "str"},
                        "privateLinkServiceConnectionState": {
                            "actionsRequired": "str",
                            "description": "str",
                            "status": "str",
                        },
                        "provisioningState": "str",
                        "systemData": {
                            "createdAt": "2020-02-20 00:00:00",
                            "createdBy": "str",
                            "createdByType": "str",
                            "lastModifiedAt": "2020-02-20 00:00:00",
                            "lastModifiedBy": "str",
                            "lastModifiedByType": "str",
                        },
                        "type": "str",
                    }
                ],
                "provisioningState": "str",
                "publicNetworkAccess": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2023-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_azure_monitor_workspaces_update(self, resource_group):
        response = self.client.azure_monitor_workspaces.update(
            resource_group_name=resource_group.name,
            azure_monitor_workspace_name="str",
            api_version="2023-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_azure_monitor_workspaces_begin_delete(self, resource_group):
        response = self.client.azure_monitor_workspaces.begin_delete(
            resource_group_name=resource_group.name,
            azure_monitor_workspace_name="str",
            api_version="2023-04-03",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
