# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dashboard.aio import DashboardManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDashboardManagementIntegrationFabricsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DashboardManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_integration_fabrics_get(self, resource_group):
        response = await self.client.integration_fabrics.get(
            resource_group_name=resource_group.name,
            workspace_name="str",
            integration_fabric_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_integration_fabrics_begin_create(self, resource_group):
        response = await (
            await self.client.integration_fabrics.begin_create(
                resource_group_name=resource_group.name,
                workspace_name="str",
                integration_fabric_name="str",
                request_body_parameters={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "dataSourceResourceId": "str",
                        "provisioningState": "str",
                        "scenarios": ["str"],
                        "targetResourceId": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_integration_fabrics_begin_update(self, resource_group):
        response = await (
            await self.client.integration_fabrics.begin_update(
                resource_group_name=resource_group.name,
                workspace_name="str",
                integration_fabric_name="str",
                request_body_parameters={"properties": {"scenarios": ["str"]}, "tags": {"str": "str"}},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_integration_fabrics_begin_delete(self, resource_group):
        response = await (
            await self.client.integration_fabrics.begin_delete(
                resource_group_name=resource_group.name,
                workspace_name="str",
                integration_fabric_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_integration_fabrics_list(self, resource_group):
        response = self.client.integration_fabrics.list(
            resource_group_name=resource_group.name,
            workspace_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
