% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXL.R
\name{readXL}
\alias{readXL}
\title{Read an Excel File}
\usage{
readXL(
  file,
  rownames = FALSE,
  header = TRUE,
  na = "",
  sheet = 1,
  stringsAsFactors = FALSE
)
}
\arguments{
\item{file}{name of an Excel file including its path.}

\item{rownames}{if \code{TRUE} (the default is \code{FALSE}), the first column in the spreadsheet contains row names (which must be unique---i.e., no duplicates).}

\item{header}{if \code{TRUE} (the default), the first row in the spreadsheet contains column (variable) names.}

\item{na}{character string denoting missing data; the default is the empty string, \code{""}.}

\item{sheet}{number of the spreadsheet in the file containing the data to be read; the default is \code{1}.}

\item{stringsAsFactors}{if \code{TRUE} (the default is \code{FALSE}) then columns containing character data are converted to factors.}
}
\value{
a data frame.
}
\description{
Read an Excel File
}
\details{
\code{readXL} reads an Excel file, either of type \code{.xls} or \code{.xlsx} into an R data frame; it provides a front end to the \code{\link[readxl]{read_excel}} function in the \pkg{readxl} package.
\code{\link[readxl]{excel_sheets}} is re-exported from the \pkg{readxl} package and reports the names of spreadsheets in an Excel file.
}
\seealso{
\code{\link[readxl]{read_excel}}, \code{\link[readxl]{excel_sheets}}.
}
\author{
John Fox
}
\keyword{manip}
