# 2024-08-06 Triage Log

This week saw several large improvements caused mostly by the [update to LLVM 19](https://github.com/rust-lang/rust/pull/127513). There were some regressions in several pull requests, but most of them were immediately fixed in a follow-up PR.

Triage done by **@kobzol**.
Revision range: [7e3a9718..8c7e0e16](https://perf.rust-lang.org/?start=7e3a971870f23c94f7aceb53b490fb37333150ff&end=8c7e0e160831866bc1a40691a39455aac21271c0&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.2%, 3.8%]    | 91    |
| Regressions ❌ <br /> (secondary)  | 1.9%  | [0.2%, 19.2%]   | 104   |
| Improvements ✅ <br /> (primary)   | -4.4% | [-15.8%, -0.3%] | 120   |
| Improvements ✅ <br /> (secondary) | -3.3% | [-10.4%, -0.2%] | 70    |
| All ❌✅ (primary)                 | -2.1% | [-15.8%, 3.8%]  | 211   |


6 Regressions, 3 Improvements, 5 Mixed; 4 of them in rollups
51 artifact comparisons made in total

#### Regressions

Rollup of 7 pull requests [#128413](https://github.com/rust-lang/rust/pull/128413) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f8060d282d42770fadd73905e3eefb85660d3278&end=249cf71f11a29b3fb68e8a35969569d8bb7958ee&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.2%, 1.9%] | 28    |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.2%, 0.4%] | 7     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.2%, 1.9%] | 28    |

- The regression was caused by https://github.com/rust-lang/rust/pull/128357.
- The regression should be fixed by https://github.com/rust-lang/rust/pull/128550.
- Marked as triaged.

Rollup of 6 pull requests [#128469](https://github.com/rust-lang/rust/pull/128469) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=28a58f2fa7f0c46b8fab8237c02471a915924fe5&end=71b211609605590423a68ba3f503e53404d4fdb4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.7%]   | 10    |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.2%, 2.1%]   | 36    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -2.5% | [-2.5%, -2.5%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [-0.2%, 0.7%]  | 11    |

- The regression was caused by https://github.com/rust-lang/rust/pull/128443.
- The regression was later fixed in https://github.com/rust-lang/rust/pull/128544.
- Marked as triaged.

Rewrite binary search implementation [#128254](https://github.com/rust-lang/rust/pull/128254) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2cec7a85ed4868c90194a2187d2751788e298197&end=19326022d243f487b5752661cd9b597d620a489e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.7%]   | 16    |
| Regressions ❌ <br /> (secondary)  | 6.2%  | [0.2%, 19.5%]  | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -4.1% | [-4.1%, -4.1%] | 1     |
| All ❌✅ (primary)                 | 0.5%  | [0.2%, 1.7%]   | 16    |

- This PR optimized the standard library implementation of binary search.
- The regression is caused by LLVM spending more time in optimizing the new binary search, because it is now more amenable to unrolling and other optimizations.
- Marked as triaged.

Rollup of 7 pull requests [#128614](https://github.com/rust-lang/rust/pull/128614) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bbf60c897e18a72923129c63ff33ce2de2968815&end=64ebd39da5ec28caa3bd7cbb3f22f5949432fe2b&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 0.8% | [0.4%, 1.3%] | 10    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

- The regression was caused by https://github.com/rust-lang/rust/pull/127921.
- The compiler now performs more work, so a small regression is expected.
- Marked as triaged.

Update the stdarch submodule [#128466](https://github.com/rust-lang/rust/pull/128466) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8f63e9f8732d8688f2b5e1c816569f65ee185c7e&end=b389b0ab72cb0aa9acf4df0ae0c0e12090782da9&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.2%, 2.6%] | 13    |
| Regressions ❌ <br /> (secondary)  | 1.0% | [0.2%, 4.3%] | 32    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.2%, 2.6%] | 13    |

- Small regression on several benchmarks, caused by the standard library becoming larger.
- Marked as triaged.

Enforce supertrait outlives obligations hold when confirming impl [#124336](https://github.com/rust-lang/rust/pull/124336) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=83e9b93c90bcd7f52d17d09b52e3a2eff707c46a&end=2b78d920964e1d70927bcd208529bda0e11120d0&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.2%, 1.5%] | 95    |
| Regressions ❌ <br /> (secondary)  | 1.8% | [0.2%, 4.2%] | 38    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.2%, 1.5%] | 95    |

- Medium regression on a lot of primary benchmarks.
- Not marking as triaged yet, investigation ongoing.

#### Improvements

Rollup of 6 pull requests [#128504](https://github.com/rust-lang/rust/pull/128504) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e60ebb2f2c1facba87e7971798f3cbdfd309cd23&end=a886938671e1fde9d7271dce8ca3d6938bae9d2e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 12    |
| All ❌✅ (primary)                 | -     | -              | 0     |


Delegation: second attempt to improve perf [#128441](https://github.com/rust-lang/rust/pull/128441) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=64ebd39da5ec28caa3bd7cbb3f22f5949432fe2b&end=8f63e9f8732d8688f2b5e1c816569f65ee185c7e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.7%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.1%, -0.1%] | 9     |
| All ❌✅ (primary)                 | -0.4% | [-0.7%, -0.2%] | 9     |

Check divergence value first before doing span operations in `warn_if_unreachable` [#128544](https://github.com/rust-lang/rust/pull/128544) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ebd08d8ed5c8904de8700def78adc1dbd5727684&end=ab1527f1d6560168f9fd36fa8cd7ba677c1d36ad&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 21    |
| Improvements ✅ <br /> (secondary) | -1.0% | [-2.1%, -0.2%] | 34    |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 21    |


#### Mixed

Delegation: support generics for delegation from free functions [#125929](https://github.com/rust-lang/rust/pull/125929) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e69c19ea0b8cf29ab8188a0eb5e899655464a1ff&end=1ddedbaa5919b7b3e70d984660e21e844c615c97&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.8%]   | 11    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.1%, 1.2%]   | 10    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 2     |
| All ❌✅ (primary)                 | 0.4%  | [0.2%, 0.8%]   | 11    |

- The regression was resolved in https://github.com/rust-lang/rust/pull/128441.
- Marked as triaged.

Update to LLVM 19 [#127513](https://github.com/rust-lang/rust/pull/127513) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e552c168c72c95dc28950a9aae8ed7030199aa0d&end=0b5eb7ba7bd796fb39c8bb6acd9ef6c140f28b65&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3%  | [0.2%, 3.6%]    | 13    |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.2%, 3.4%]    | 37    |
| Improvements ✅ <br /> (primary)   | -3.2% | [-15.8%, -0.2%] | 172   |
| Improvements ✅ <br /> (secondary) | -2.6% | [-10.5%, -0.2%] | 82    |
| All ❌✅ (primary)                 | -2.9% | [-15.8%, 3.6%]  | 185   |

- This was a large performance increase caused by an update to LLVM 19.
- Improvement far outweigh the regressions.
- Marked as triaged.

Accelerate GVN a little [#126991](https://github.com/rust-lang/rust/pull/126991) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=99322d84c4e216940621c356787331d8ae362326&end=28a58f2fa7f0c46b8fab8237c02471a915924fe5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 2.1%  | [2.1%, 2.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.0%, -0.4%] | 6     |
| All ❌✅ (primary)                 | -0.2% | [-0.4%, 0.3%]  | 3     |

- More improvements than regressions.
- Marked as triaged.

Revert recent changes to dead code analysis [#128404](https://github.com/rust-lang/rust/pull/128404) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ad0a2b7180c06514370c4c7a7a73ee75158e88fa&end=1f47624f9abad7974afe1c016a4e8b07f4254ee4&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [0.7%, 1.7%]    | 9     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.2%, -0.2%]  | 47    |
| Improvements ✅ <br /> (secondary) | -2.9% | [-10.7%, -0.2%] | 15    |
| All ❌✅ (primary)                 | -0.4% | [-1.2%, -0.2%]  | 47    |

- More improvements than regressions.
- Marked as triaged.

Change output normalization logic to be linear against size of output [#128200](https://github.com/rust-lang/rust/pull/128200) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c9687a95a602091777e28703aa5abf20f1ce1797&end=8c7e0e160831866bc1a40691a39455aac21271c0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.5%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-2.6%, -0.2%] | 19    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.7%, -0.3%] | 10    |
| All ❌✅ (primary)                 | -0.9% | [-2.6%, -0.2%] | 19    |

- This PR fixed a small regression from https://github.com/rust-lang/rust/pull/127528.
- More improvements than regressions.
- Marked as triaged.
