// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyTestTopPriority = 2,
    CSSPropertyTestHighPriority = 3,
    CSSPropertyTestMediumPriority = 4,
    CSSPropertyBackgroundCoordinatedValueListPropertyTestDiscrete = 5,
    CSSPropertyBackgroundCoordinatedValueListPropertyTestTwo = 6,
    CSSPropertyFirstTestDescriptorForFirstDescriptor = 7,
    CSSPropertyFirstTestDescriptorForSecondDescriptor = 8,
    CSSPropertyTestAnimationWrapper = 9,
    CSSPropertyTestAnimationWrapperAccelerationAlways = 10,
    CSSPropertyTestAnimationWrapperAccelerationThreadedOnly = 11,
    CSSPropertyTestBoundedRepetitionWithCommas = 12,
    CSSPropertyTestBoundedRepetitionWithCommasFixed = 13,
    CSSPropertyTestBoundedRepetitionWithCommasNoSingleItemOpt = 14,
    CSSPropertyTestBoundedRepetitionWithCommasSingleItemOpt = 15,
    CSSPropertyTestBoundedRepetitionWithSpaces = 16,
    CSSPropertyTestBoundedRepetitionWithSpacesFixed = 17,
    CSSPropertyTestBoundedRepetitionWithSpacesNoSingleItemOpt = 18,
    CSSPropertyTestBoundedRepetitionWithSpacesSingleItemOpt = 19,
    CSSPropertyTestBoundedRepetitionWithSpacesWithType = 20,
    CSSPropertyTestBoundedRepetitionWithSpacesWithTypeNoSingleItemOpt = 21,
    CSSPropertyTestBoundedRepetitionWithSpacesWithTypeWithDefaultPrevious = 22,
    CSSPropertyTestBoundedRepetitionWithSpacesWithTypeWithDefaultPreviousTwo = 23,
    CSSPropertyTestColor = 24,
    CSSPropertyTestColorAllowsTypesAbsolute = 25,
    CSSPropertyTestColorPropertyWithNoVisitedLinkSupport = 26,
    CSSPropertyTestColorPropertyWithVisitedLinkSupport = 27,
    CSSPropertyTestCustomExtractor = 28,
    CSSPropertyTestFunctionBoundedParameters = 29,
    CSSPropertyTestFunctionFixedParameters = 30,
    CSSPropertyTestFunctionNoParameters = 31,
    CSSPropertyTestFunctionParametersMatchAllAnyOrder = 32,
    CSSPropertyTestFunctionParametersMatchAllAnyOrderWithOptional = 33,
    CSSPropertyTestFunctionParametersMatchAllOrdered = 34,
    CSSPropertyTestFunctionParametersMatchAllOrderedWithOptional = 35,
    CSSPropertyTestFunctionParametersMatchOneOrMoreAnyOrder = 36,
    CSSPropertyTestFunctionSingleParameter = 37,
    CSSPropertyTestFunctionSingleParameterMatchOne = 38,
    CSSPropertyTestFunctionSingleParameterOptional = 39,
    CSSPropertyTestFunctionUnboundedParametersNoMin = 40,
    CSSPropertyTestFunctionUnboundedParametersWithMinimum = 41,
    CSSPropertyTestImage = 42,
    CSSPropertyTestImageNoImageSet = 43,
    CSSPropertyTestKeyword = 44,
    CSSPropertyTestKeywordWithAliasedTo = 45,
    CSSPropertyTestMatchAllAnyOrder = 46,
    CSSPropertyTestMatchAllAnyOrderWithCustomType = 47,
    CSSPropertyTestMatchAllAnyOrderWithOptional = 48,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndCustomType = 49,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndCustomType = 50,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndCustomTypeNoSingleItemOpt = 51,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndPreserveOrderAndCustomType = 52,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndPreserveOrderAndCustomTypeNoSingleItemOpt = 53,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndPreserveOrderAndCustomType = 54,
    CSSPropertyTestMatchAllAnyOrderWithOptionalNoSingleItemOpt = 55,
    CSSPropertyTestMatchAllAnyOrderWithOptionalSingleItemOpt = 56,
    CSSPropertyTestMatchAllAnyOrderWithOptionalWithPreserveOrder = 57,
    CSSPropertyTestMatchAllAnyOrderWithOptionalWithPreserveOrderNoSingleItemOpt = 58,
    CSSPropertyTestMatchAllAnyOrderWithPreserveOrder = 59,
    CSSPropertyTestMatchAllAnyOrderWithPreserveOrderAndCustomType = 60,
    CSSPropertyTestMatchAllAnyOrderWithPreserveOrderNoSingleItemOpt = 61,
    CSSPropertyTestMatchAllOrdered = 62,
    CSSPropertyTestMatchAllOrderedWithCustomType = 63,
    CSSPropertyTestMatchAllOrderedWithOptional = 64,
    CSSPropertyTestMatchAllOrderedWithOptionalAndCustomType = 65,
    CSSPropertyTestMatchAllOrderedWithOptionalAndCustomTypeAndNoSingleItemOpt = 66,
    CSSPropertyTestMatchAllOrderedWithOptionalAndMultipleRequired = 67,
    CSSPropertyTestMatchAllOrderedWithOptionalAndMultipleRequiredAndCustomType = 68,
    CSSPropertyTestMatchAllOrderedWithOptionalNoSingleItemOpt = 69,
    CSSPropertyTestMatchAllOrderedWithOptionalSingleItemOpt = 70,
    CSSPropertyTestMatchOne = 71,
    CSSPropertyTestMatchOneOrMoreAnyOrder = 72,
    CSSPropertyTestMatchOneOrMoreAnyOrderNoSingleItemOpt = 73,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithCustomType = 74,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithCustomTypeNoSingleItemOpt = 75,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrder = 76,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrderAndCustomType = 77,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrderAndCustomTypeNoSingleItemOpt = 78,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrderNoSingleItemOpt = 79,
    CSSPropertyTestMatchOneWithGroupWithSettingsFlag = 80,
    CSSPropertyTestMatchOneWithKeywordWithSettingsFlag = 81,
    CSSPropertyTestMatchOneWithMultipleKeywords = 82,
    CSSPropertyTestMatchOneWithReferenceWithSettingsFlag = 83,
    CSSPropertyTestMatchOneWithSettingsFlag = 84,
    CSSPropertyTestNumericValueRange = 85,
    CSSPropertyTestProperty = 86,
    CSSPropertyTestRenderStyleStorageOneLevelEnum = 87,
    CSSPropertyTestRenderStyleStorageOneLevelRaw = 88,
    CSSPropertyTestRenderStyleStorageOneLevelReference = 89,
    CSSPropertyTestRenderStyleStorageOneLevelValue = 90,
    CSSPropertyTestRenderStyleStorageTwoLevelEnum = 91,
    CSSPropertyTestRenderStyleStorageTwoLevelRaw = 92,
    CSSPropertyTestRenderStyleStorageTwoLevelReference = 93,
    CSSPropertyTestRenderStyleStorageTwoLevelValue = 94,
    CSSPropertyTestSettingsOne = 95,
    CSSPropertyTestUnboundedRepetitionWithCommasWithMin = 96,
    CSSPropertyTestUnboundedRepetitionWithCommasWithMinNoSingleItemOpt = 97,
    CSSPropertyTestUnboundedRepetitionWithCommasWithMinSingleItemOpt = 98,
    CSSPropertyTestUnboundedRepetitionWithSpacesNoMin = 99,
    CSSPropertyTestUnboundedRepetitionWithSpacesNoMinNoSingleItemOpt = 100,
    CSSPropertyTestUnboundedRepetitionWithSpacesWithMin = 101,
    CSSPropertyTestUnboundedRepetitionWithSpacesWithMinNoSingleItemOpt = 102,
    CSSPropertyTestUnboundedRepetitionWithSpacesWithMinSingleItemOpt = 103,
    CSSPropertyTestUrlWithModifiers = 104,
    CSSPropertyTestUrlWithNoModifiers = 105,
    CSSPropertyTestUsingSharedRule = 106,
    CSSPropertyTestUsingSharedRuleExported = 107,
    CSSPropertyTestUsingSharedRuleWithOverrideFunction = 108,
    CSSPropertyTestSinkPriority = 109,
    CSSPropertyTestLogicalPropertyGroupPhysicalHorizontal = 110,
    CSSPropertyTestLogicalPropertyGroupPhysicalVertical = 111,
    CSSPropertyTestLogicalPropertyGroupLogicalBlock = 112,
    CSSPropertyTestLogicalPropertyGroupLogicalInline = 113,
    CSSPropertyAll = 114,
    CSSPropertyFont = 115,
    CSSPropertyTestShorthandOne = 116,
    CSSPropertyTestShorthandTwo = 117,
};

// Enum value of the first "real" CSS property, which excludes
// CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t firstCSSProperty = 2;
// Total number of enum values in the CSSPropertyID enum. If making an array
// that can be indexed into using the enum value, use this as the size.
constexpr uint16_t cssPropertyIDEnumValueCount = 118;
// Number of "real" CSS properties. This differs from cssPropertyIDEnumValueCount,
// as this doesn't consider CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t numCSSProperties = 116;
constexpr unsigned maxCSSPropertyNameLength = 114;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyTestTopPriority;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyTestTopPriority;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyTestHighPriority;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyTestHighPriority;
constexpr auto firstMediumPriorityProperty = CSSPropertyID::CSSPropertyTestMediumPriority;
constexpr auto lastMediumPriorityProperty = CSSPropertyID::CSSPropertyTestMediumPriority;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyBackgroundCoordinatedValueListPropertyTestDiscrete;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyTestSinkPriority;
constexpr auto firstLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyTestLogicalPropertyGroupPhysicalHorizontal;
constexpr auto lastLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyTestLogicalPropertyGroupPhysicalVertical;
constexpr auto firstLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyTestLogicalPropertyGroupLogicalBlock;
constexpr auto lastLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyTestLogicalPropertyGroupLogicalInline;
constexpr auto firstLogicalGroupProperty = firstLogicalGroupPhysicalProperty;
constexpr auto lastLogicalGroupProperty = lastLogicalGroupLogicalProperty;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyTestShorthandTwo;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;

extern const std::array<CSSPropertyID, 16> computedPropertyIDs;

template<CSSPropertyID C> struct PropertyNameConstant {
    static constexpr auto value = C;
    constexpr bool operator==(const PropertyNameConstant&) const = default;
    constexpr bool operator==(CSSPropertyID other) const { return value == other; }
};

struct CSSPropertySettings {
    WTF_DEPRECATED_MAKE_STRUCT_FAST_ALLOCATED(CSSPropertySettings);

    bool cssDescriptorEnabled : 1 { false };
    bool cssSettingsOneEnabled : 1 { false };
    bool cssSettingsShorthandEnabled : 1 { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID cascadeAliasProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastLogicalGroupProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty
        && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

constexpr bool isLogicalPropertyGroupProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

constexpr bool isLogicalPropertyGroupPhysicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupPhysicalProperty);
}

constexpr bool isLogicalPropertyGroupLogicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupLogicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

WTF::TextStream& operator<<(WTF::TextStream&, CSSPropertyID);

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

