; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=i386-apple-darwin9.6 < %s | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc -mtriple=x86_64-apple-darwin < %s | FileCheck %s --check-prefixes=CHECK,X64

define i32 @test1() nounwind {
; CHECK-LABEL: test1:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    movw %gs:6, %ax
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    movzwl %ax, %eax
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %asmtmp.i = tail call i16 asm "movw\09%gs:${1:a}, ${0:w}", "=r,ir,~{dirflag},~{fpsr},~{flags}"(i32 6) nounwind ; <i16> [#uses=1]
  %0 = zext i16 %asmtmp.i to i32                  ; <i32> [#uses=1]
  ret i32 %0
}

define zeroext i16 @test2(i32 %address) nounwind {
; X86-LABEL: test2:
; X86:       ## %bb.0: ## %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    ## InlineAsm Start
; X86-NEXT:    movw %gs:(%eax), %ax
; X86-NEXT:    ## InlineAsm End
; X86-NEXT:    movzwl %ax, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test2:
; X64:       ## %bb.0: ## %entry
; X64-NEXT:    ## InlineAsm Start
; X64-NEXT:    movw %gs:(%edi), %ax
; X64-NEXT:    ## InlineAsm End
; X64-NEXT:    movzwl %ax, %eax
; X64-NEXT:    retq
entry:
  %asmtmp = tail call i16 asm "movw\09%gs:${1:a}, ${0:w}", "=r,ir,~{dirflag},~{fpsr},~{flags}"(i32 %address) nounwind ; <i16> [#uses=1]
  ret i16 %asmtmp
}

@n = global i32 42                                ; <ptr> [#uses=3]
@y = common global i32 0                          ; <ptr> [#uses=3]

define void @test3() nounwind {
; X86-LABEL: test3:
; X86:       ## %bb.0: ## %entry
; X86-NEXT:    ## InlineAsm Start
; X86-NEXT:    movl _n, %eax
; X86-NEXT:    ## InlineAsm End
; X86-NEXT:    retl
;
; X64-LABEL: test3:
; X64:       ## %bb.0: ## %entry
; X64-NEXT:    ## InlineAsm Start
; X64-NEXT:    movl _n(%rip), %eax
; X64-NEXT:    ## InlineAsm End
; X64-NEXT:    retq
entry:
  call void asm sideeffect "movl ${0:a}, %eax", "ir,~{dirflag},~{fpsr},~{flags},~{eax}"(ptr @n) nounwind
  ret void
}

define void @test4() nounwind {
; X86-LABEL: test4:
; X86:       ## %bb.0: ## %entry
; X86-NEXT:    movl L_y$non_lazy_ptr, %ecx
; X86-NEXT:    ## InlineAsm Start
; X86-NEXT:    movl (%ecx), %eax
; X86-NEXT:    ## InlineAsm End
; X86-NEXT:    retl
;
; X64-LABEL: test4:
; X64:       ## %bb.0: ## %entry
; X64-NEXT:    movq _y@GOTPCREL(%rip), %rcx
; X64-NEXT:    ## InlineAsm Start
; X64-NEXT:    movl (%rcx), %eax
; X64-NEXT:    ## InlineAsm End
; X64-NEXT:    retq
entry:
  call void asm sideeffect "movl ${0:a}, %eax", "ir,~{dirflag},~{fpsr},~{flags},~{eax}"(ptr @y) nounwind
  ret void
}
