# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
from msrest import Serializer, Deserializer


class {{ client_name }}OperationsMixin(object):

{% for operation_name, metadata in mixin_operations|dictsort %}
    def {{ operation_name }}{{ metadata['signature'] }}:
        """{{ metadata['doc'] }}
        """
        api_version = self._get_api_version('{{ operation_name }}')
{%- for api in metadata['available_apis'] %}
        {% if not loop.first %}el{% endif %}if api_version == '{{ mod_to_api_version[api] }}':
            from .{{ api }}.operations import {{ client_name }}OperationsMixin as OperationClass
{%- endfor %}
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        mixin_instance.api_version = api_version
        return mixin_instance.{{ operation_name }}({{ metadata['call'] }}, **operation_config)
{% endfor %}