% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_formals.R
\name{ard_formals}
\alias{ard_formals}
\title{Argument Values ARD}
\usage{
ard_formals(fun, arg_names, passed_args = list(), envir = parent.frame())
}
\arguments{
\item{fun}{(\code{function})\cr
a \link{function} passed to \code{formals(fun)}}

\item{arg_names}{(\code{character})\cr
character vector of argument names to return}

\item{passed_args}{(named \code{list})\cr
a named list of user-passed arguments. Default is \code{list()}, which returns
all default values from a function}

\item{envir}{(\code{environment})\cr
an environment passed to \code{formals(envir)}}
}
\value{
an partial ARD data frame of class 'card'
}
\description{
Place default and passed argument values to a function into an ARD structure.
}
\examples{
# Example 1 ----------------------------------
# add the `mcnemar.test(correct)` argument to an ARD structure
ard_formals(fun = mcnemar.test, arg_names = "correct")

# Example 2 ----------------------------------
# S3 Methods need special handling to access the underlying method
ard_formals(
  fun = asNamespace("stats")[["t.test.default"]],
  arg_names = c("mu", "paired", "var.equal", "conf.level"),
  passed_args = list(conf.level = 0.90)
)
}
