% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2ld.R
\name{LD22}
\alias{LD22}
\title{LD statistics for two diallelic markers}
\usage{
LD22(h, n)
}
\arguments{
\item{h}{a vector of haplotype frequencies.}

\item{n}{number of haplotypes.}
}
\value{
The returned value is a list containing:
\itemize{
\item h the original haplotype frequency vector.
\item n the number of haplotypes.
\item D the linkage disequilibrium parameter.
\item VarD the variance of D.
\item Dmax the maximum of D.
\item VarDmax the variance of Dmax.
\item Dprime the scaled disequilibrium parameter.
\item VarDprime the variance of Dprime.
\item x2 the Chi-squared statistic.
\item lor the log(OR) statistic.
\item vlor the var(log(OR)) statistic.
}
}
\description{
LD statistics for two diallelic markers
}
\details{
It is possible to perform permutation test of \eqn{r^2} by re-ordering the genotype through
R's sample function, obtaining the haplotype frequencies by \code{\link{gc.em}}
or \code{\link{genecounting}}, supplying the estimated haplotype frequencies to
the current function and record x2, and comparing the observed x2 and that from the
replicates.
}
\note{
extracted from 2ld.c, worked 28/6/03, tables are symmetric do not fix, see kbyl below
}
\examples{
\dontrun{
h <- c(0.442356,0.291532,0.245794,0.020319)
n <- 481*2
t <- LD22(h,n)
}

}
\references{
\insertRef{zabetian03}{gap}

\insertRef{zapata97}{gap}
}
\seealso{
\code{\link{LDkl}}
}
\author{
Jing Hua Zhao
}
\keyword{models}
