% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_forecast.R
\name{autoplot.forecast}
\alias{autoplot.forecast}
\title{Autoplot \code{forecast::forecast}}
\usage{
\method{autoplot}{forecast}(
  object,
  is.date = NULL,
  ts.connect = TRUE,
  predict.geom = "line",
  predict.colour = "#0000FF",
  predict.size = NULL,
  predict.linetype = NULL,
  predict.alpha = NULL,
  predict.fill = NULL,
  predict.shape = NULL,
  conf.int = TRUE,
  conf.int.colour = "#0000FF",
  conf.int.linetype = "none",
  conf.int.fill = "#000000",
  conf.int.alpha = 0.3,
  ...
)
}
\arguments{
\item{object}{\code{forecast::forecast} instance}

\item{is.date}{Logical frag indicates whether the \code{stats::ts} is date or not.
If not provided, regard the input as date when the frequency is 4 or 12}

\item{ts.connect}{Logical frag indicates whether connects original time-series and predicted values}

\item{predict.geom}{geometric string for predicted time-series}

\item{predict.colour}{line colour for predicted time-series}

\item{predict.size}{point size for predicted time-series}

\item{predict.linetype}{line type for predicted time-series}

\item{predict.alpha}{alpha for predicted time-series}

\item{predict.fill}{fill colour for predicted time-series}

\item{predict.shape}{point shape for predicted time-series}

\item{conf.int}{Logical flag indicating whether to plot confidence intervals}

\item{conf.int.colour}{line colour for confidence intervals}

\item{conf.int.linetype}{line type for confidence intervals}

\item{conf.int.fill}{fill colour for confidence intervals}

\item{conf.int.alpha}{alpha for confidence intervals}

\item{...}{other arguments passed to \code{autoplot.ts}}
}
\value{
ggplot
}
\description{
Autoplot \code{forecast::forecast}
}
\examples{
\dontrun{
d.arima <- forecast::auto.arima(AirPassengers)
autoplot(forecast::forecast(d.arima, h = 10))
autoplot(forecast::forecast(d.arima, level = c(85), h = 10))
autoplot(forecast::forecast(d.arima, h = 5), conf.int = FALSE, is.date = FALSE)
autoplot(forecast::forecast(stats::HoltWinters(UKgas), h = 10))
autoplot(forecast::forecast(forecast::ets(UKgas), h = 5))
}
}
